/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.retry;

import com.gooddata.GoodDataRestException;
import com.gooddata.retry.RetryStrategy;
import java.net.URI;
import org.apache.commons.lang3.Validate;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class RetryableRestTemplate
extends RestTemplate {
    private final RetryTemplate retryTemplate;
    private final RetryStrategy retryStrategy;

    public RetryableRestTemplate(ClientHttpRequestFactory requestFactory, RetryTemplate retryTemplate, RetryStrategy retryStrategy) {
        super(requestFactory);
        Validate.notNull((Object)retryTemplate);
        this.retryTemplate = retryTemplate;
        this.retryStrategy = retryStrategy;
    }

    protected <T> T doExecute(URI url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        return (T)this.retryTemplate.execute(context -> {
            System.out.println("Retrying " + context.getRetryCount() + " " + method + " ");
            try {
                return super.doExecute(url, method, requestCallback, responseExtractor);
            }
            catch (GoodDataRestException e) {
                if (!this.retryStrategy.retryAllowed(method.toString(), e.getStatusCode(), url)) {
                    context.setExhaustedOnly();
                }
                throw e;
            }
        });
    }
}

