/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.gdc;

import com.github.sardine.impl.SardineException;
import com.gooddata.gdc.GdcSardineException;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ResponseHandler;

class GdcSardineResponseHandler
implements ResponseHandler<Void> {
    GdcSardineResponseHandler() {
    }

    public Void handleResponse(HttpResponse response) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        if (statusCode >= 200 && statusCode < 300) {
            return null;
        }
        Header requestIdHeader = response.getFirstHeader("X-GDC-REQUEST");
        if (requestIdHeader != null) {
            throw new GdcSardineException(requestIdHeader.getValue(), "Unexpected response", statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        throw new SardineException("Unexpected response", statusLine.getStatusCode(), statusLine.getReasonPhrase());
    }
}

