/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.util;

import com.gooddata.util.Validate;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.springframework.util.StreamUtils;

public abstract class ZipHelper {
    public static void zip(File file, OutputStream output) throws IOException {
        ZipHelper.zip(file, output, false);
    }

    public static void zip(File file, OutputStream output, boolean includeRoot) throws IOException {
        Validate.notNull((Object)file, (String)"file");
        Validate.notNull((Object)output, (String)"output");
        if (ZipHelper.isZipped(file)) {
            try (InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);){
                StreamUtils.copy((InputStream)fis, (OutputStream)output);
            }
        }
        try (ZipOutputStream zos = new ZipOutputStream(output);){
            if (file.isDirectory()) {
                ZipHelper.zipDir(includeRoot ? file.getParentFile().toPath() : file.toPath(), file, zos);
            } else {
                ZipHelper.zipFile(file.getParentFile().toPath(), file, zos);
            }
        }
    }

    private static void zipDir(Path rootPath, File dir, ZipOutputStream zos) throws IOException {
        for (File file : (File[])Validate.notNull((Object)dir.listFiles(), (String)"listed files")) {
            if (file.isDirectory()) {
                ZipHelper.zipDir(rootPath, file, zos);
                continue;
            }
            ZipHelper.zipFile(rootPath, file, zos);
        }
    }

    private static void zipFile(Path rootPath, File file, ZipOutputStream zos) throws IOException {
        ZipEntry ze = new ZipEntry(rootPath.relativize(file.toPath()).toString());
        zos.putNextEntry(ze);
        try (InputStream fis = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            StreamUtils.copy((InputStream)fis, (OutputStream)zos);
        }
        zos.closeEntry();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean isZipped(File file) {
        try (InputStream stream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            boolean bl;
            try (ZipInputStream zipStream = new ZipInputStream(stream);){
                bl = zipStream.getNextEntry() != null;
            }
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }
}

