/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.md;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.gooddata.md.Attachment;
import com.gooddata.report.ReportExportFormat;
import com.gooddata.util.GoodDataToStringBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class ReportAttachment
extends Attachment {
    private final Collection<String> formats;
    private final Map<String, String> exportOptions;

    @JsonCreator
    protected ReportAttachment(@JsonProperty(value="uri") String uri, @JsonProperty(value="exportOptions") Map<String, String> exportOptions, String ... formats) {
        super(uri);
        this.exportOptions = exportOptions;
        this.formats = Arrays.asList(formats);
    }

    protected ReportAttachment(String uri, Map<String, String> exportOptions, ReportExportFormat ... formats) {
        this(uri, exportOptions, ReportExportFormat.arrayToStringArray(formats));
    }

    public Map<String, String> getExportOptions() {
        return this.exportOptions;
    }

    public Collection<String> getFormats() {
        return this.formats;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportAttachment that = (ReportAttachment)o;
        if (this.formats != null ? !this.formats.equals(that.formats) : that.formats != null) {
            return false;
        }
        return !(this.exportOptions == null ? that.exportOptions != null : !this.exportOptions.equals(that.exportOptions));
    }

    @Override
    public int hashCode() {
        int result = this.formats != null ? this.formats.hashCode() : 0;
        result = 31 * result + (this.exportOptions != null ? this.exportOptions.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return new GoodDataToStringBuilder(this).append("uri", this.getUri()).toString();
    }
}

