/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.md;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.md.AbstractObj;
import com.gooddata.md.Meta;
import com.gooddata.md.Queryable;
import com.gooddata.util.GoodDataToStringBuilder;

@JsonTypeName(value="tableDataLoad")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
public class TableDataLoad
extends AbstractObj
implements Queryable {
    public static final String TYPE_FULL = "full";
    public static final String TYPE_INCREMENTAL = "incremental";
    private final Content content;

    @JsonCreator
    private TableDataLoad(@JsonProperty(value="meta") Meta meta, @JsonProperty(value="content") Content content) {
        super(meta);
        this.content = content;
    }

    public String getDataSourceLocation() {
        return this.content.getDataSourceLocation();
    }

    public boolean isFull() {
        return TYPE_FULL.equals(this.getType());
    }

    public boolean isIncremental() {
        return TYPE_INCREMENTAL.equals(this.getType());
    }

    public String getType() {
        return this.content.getTypeOfLoad();
    }

    @Override
    public String toString() {
        return GoodDataToStringBuilder.defaultToString(this, new String[0]);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class Content {
        private final String dataSourceLocation;
        private final String typeOfLoad;

        @JsonCreator
        private Content(@JsonProperty(value="dataSourceLocation") String dataSourceLocation, @JsonProperty(value="typeOfLoad") String typeOfLoad) {
            this.dataSourceLocation = dataSourceLocation;
            this.typeOfLoad = typeOfLoad;
        }

        public String getDataSourceLocation() {
            return this.dataSourceLocation;
        }

        public String getTypeOfLoad() {
            return this.typeOfLoad;
        }

        public String toString() {
            return GoodDataToStringBuilder.defaultToString(this, new String[0]);
        }
    }
}

