/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.dataload.processes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.dataload.processes.ProcessType;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.UriTemplate;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="process")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DataloadProcess {
    public static final String URI = "/gdc/projects/{projectId}/dataload/processes/{processId}";
    public static final UriTemplate TEMPLATE = new UriTemplate("/gdc/projects/{projectId}/dataload/processes/{processId}");
    private static final String SELF_LINK = "self";
    private static final String EXECUTIONS_LINK = "executions";
    private String name;
    private String type;
    private Set<String> executables;
    private Map<String, String> links;
    private String path;

    public DataloadProcess(String name, String type) {
        this.name = Validate.notEmpty(name, "name");
        this.type = Validate.notEmpty(type, "type");
    }

    public DataloadProcess(String name, String type, String appstorePath) {
        this(name, type);
        this.path = appstorePath;
    }

    public DataloadProcess(String name, ProcessType type) {
        this(name, Validate.notNull(type, "type").toString());
    }

    @JsonCreator
    private DataloadProcess(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type, @JsonProperty(value="executables") Set<String> executables, @JsonProperty(value="links") Map<String, String> links) {
        this(name, type);
        this.executables = executables != null ? Collections.unmodifiableSet(executables) : null;
        this.links = links;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @JsonIgnore
    public Set<String> getExecutables() {
        return this.executables;
    }

    @JsonIgnore
    public String getUri() {
        return Validate.notNullState(this.links, "links").get(SELF_LINK);
    }

    @JsonIgnore
    public String getId() {
        return (String)TEMPLATE.match(this.getUri()).get("processId");
    }

    @Deprecated
    @JsonIgnore
    public String getExecutionsLink() {
        return this.getExecutionsUri();
    }

    @JsonIgnore
    public String getExecutionsUri() {
        return Validate.notNullState(this.links, "links").get(EXECUTIONS_LINK);
    }

    @Deprecated
    @JsonIgnore
    public String getSourceLink() {
        return this.getSourceUri();
    }

    @JsonIgnore
    public String getSourceUri() {
        return this.getUri() + "/source";
    }

    public void validateExecutable(String executable) {
        if (!CollectionUtils.isEmpty(this.getExecutables()) && !this.getExecutables().contains(executable)) {
            throw new IllegalArgumentException("Executable " + executable + " not found in process executables " + this.getExecutables());
        }
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString(this, new String[0]);
    }
}

