/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.warehouse;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import java.util.Map;
import org.springframework.web.util.UriTemplate;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="user")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WarehouseUser {
    public static final String URI = "/gdc/datawarehouse/instances/{id}/users/{userId}";
    public static final UriTemplate TEMPLATE = new UriTemplate("/gdc/datawarehouse/instances/{id}/users/{userId}");
    public static final String ADMIN_ROLE = "admin";
    public static final String DATA_ADMIN_ROLE = "dataAdmin";
    private static final String SELF_LINK = "self";
    private final String role;
    private final String profile;
    private final String login;
    private Map<String, String> links;

    public WarehouseUser(String role, String profile, String login) {
        this.role = Validate.notNull(role, "role");
        if (profile == null) {
            Validate.notNull(login, "login");
        }
        if (login == null) {
            Validate.notNull(profile, "profile");
        }
        this.profile = profile;
        this.login = login;
    }

    @JsonCreator
    public WarehouseUser(@JsonProperty(value="role") String role, @JsonProperty(value="profile") String profile, @JsonProperty(value="login") String login, @JsonProperty(value="links") Map<String, String> links) {
        this(role, profile, login);
        this.links = links;
    }

    public String getRole() {
        return this.role;
    }

    public String getProfile() {
        return this.profile;
    }

    public String getLogin() {
        return this.login;
    }

    public Map<String, String> getLinks() {
        return this.links;
    }

    @JsonIgnore
    public String getId() {
        return (String)TEMPLATE.match(this.getUri()).get("userId");
    }

    @JsonIgnore
    public String getUri() {
        return Validate.notNullState(this.links, "links").get(SELF_LINK);
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString(this, new String[0]);
    }
}

