/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.dataset;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.gooddata.dataset.UploadMode;
import com.gooddata.util.BooleanDeserializer;
import com.gooddata.util.BooleanIntegerSerializer;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="dataSetSLIManifest")
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DatasetManifest {
    public static final String URI = "/gdc/md/{projectId}/ldm/singleloadinterface/{dataSet}/manifest";
    private final String dataSet;
    private String file;
    private List<Part> parts;
    private InputStream source;

    public DatasetManifest(String dataSet) {
        this.dataSet = dataSet;
    }

    public DatasetManifest(String dataSet, InputStream source) {
        this.source = Validate.notNull(source, "source");
        this.dataSet = Validate.notEmpty(dataSet, "dataSet");
    }

    @JsonCreator
    public DatasetManifest(@JsonProperty(value="dataSet") String dataSet, @JsonProperty(value="file") String file, @JsonProperty(value="parts") List<Part> parts) {
        this.dataSet = dataSet;
        this.file = file;
        this.parts = parts;
    }

    public String getDataSet() {
        return this.dataSet;
    }

    public List<Part> getParts() {
        return this.parts;
    }

    public void setParts(List<Part> parts) {
        this.parts = parts;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = Validate.notEmpty(file, "file");
    }

    public void setUploadMode(UploadMode uploadMode) {
        Validate.notNull(uploadMode, "uploadMode");
        for (Part part : this.parts) {
            part.setUploadMode(uploadMode.name());
        }
    }

    public void setMapping(String columnName, String populates) {
        Validate.notNull(columnName, "columnName");
        Validate.notNull(populates, "populates");
        for (Part part : this.parts) {
            if (part.getPopulates() == null || part.getPopulates().size() != 1) {
                throw new IllegalStateException("Only parts with exactly one populates are supported " + part.getPopulates());
            }
            String field = part.getPopulates().iterator().next();
            if (!populates.equals(field)) continue;
            part.setColumnName(columnName);
            return;
        }
        throw new IllegalArgumentException("Dataset manifest parts doesn't contain populate value " + populates);
    }

    @JsonIgnore
    public InputStream getSource() {
        return this.source;
    }

    @JsonIgnore
    public void setSource(InputStream source) {
        this.source = Validate.notNull(source, "source");
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString(this, "source");
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Part {
        @JsonProperty(value="mode")
        private String uploadMode;
        private String columnName;
        private List<String> populates;
        private Boolean referenceKey;
        private Map<String, String> constraints;

        @JsonCreator
        public Part(@JsonProperty(value="mode") String uploadMode, @JsonProperty(value="columnName") String columnName, @JsonProperty(value="populates") List<String> populates, @JsonProperty(value="referenceKey") @JsonDeserialize(using=BooleanDeserializer.class) Boolean referenceKey, @JsonProperty(value="constraints") Map<String, String> constraints) {
            this.uploadMode = uploadMode;
            this.columnName = columnName;
            this.populates = populates;
            this.referenceKey = referenceKey;
            this.constraints = constraints;
        }

        public String getUploadMode() {
            return this.uploadMode;
        }

        public void setUploadMode(String uploadMode) {
            this.uploadMode = uploadMode;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public List<String> getPopulates() {
            return this.populates;
        }

        public void setPopulates(List<String> populates) {
            this.populates = populates;
        }

        @JsonIgnore
        public boolean isReferenceKey() {
            return Boolean.TRUE.equals(this.referenceKey);
        }

        @JsonSerialize(using=BooleanIntegerSerializer.class)
        public Boolean getReferenceKey() {
            return this.referenceKey;
        }

        public void setReferenceKey(boolean referenceKey) {
            this.referenceKey = referenceKey;
        }

        public Map<String, String> getConstraints() {
            return this.constraints;
        }

        public void setConstraints(Map<String, String> constraints) {
            this.constraints = constraints;
        }

        public String toString() {
            return GoodDataToStringBuilder.defaultToString(this, new String[0]);
        }
    }
}

