/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.featureflag;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import org.springframework.web.util.UriTemplate;

@JsonTypeName(value="featureFlag")
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProjectFeatureFlag {
    public static final String PROJECT_FEATURE_FLAG_URI = "/gdc/projects/{id}/projectFeatureFlags/{featureFlag}";
    public static final UriTemplate PROJECT_FEATURE_FLAG_TEMPLATE = new UriTemplate("/gdc/projects/{id}/projectFeatureFlags/{featureFlag}");
    private final String name;
    private boolean enabled;
    @JsonIgnore
    private final Links links;

    public ProjectFeatureFlag(String name) {
        this(Validate.notEmpty(name, "name"), true, null);
    }

    public ProjectFeatureFlag(String name, boolean enabled) {
        this(Validate.notEmpty(name, "name"), enabled, null);
    }

    @JsonCreator
    ProjectFeatureFlag(@JsonProperty(value="key") String name, @JsonProperty(value="value") boolean enabled, @JsonProperty(value="links") Links links) {
        this.name = name;
        this.enabled = enabled;
        this.links = links;
    }

    @JsonProperty(value="key")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="value")
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @JsonIgnore
    public String getUri() {
        return Validate.notNullState(this.links, "links").getSelf();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectFeatureFlag that = (ProjectFeatureFlag)o;
        if (this.enabled != that.enabled) {
            return false;
        }
        return !(this.name == null ? that.name != null : !this.name.equals(that.name));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.enabled ? 1 : 0);
        return result;
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString(this, new String[0]);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class Links {
        private final String self;

        @JsonCreator
        public Links(@JsonProperty(value="self") String self) {
            this.self = self;
        }

        public String getSelf() {
            return this.self;
        }

        public String toString() {
            return GoodDataToStringBuilder.defaultToString(this, new String[0]);
        }
    }
}

