/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service;

import com.gooddata.sdk.service.GoodData;
import com.gooddata.sdk.service.retry.RetrySettings;
import com.gooddata.util.GoodDataToStringBuilder;
import com.gooddata.util.Validate;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.VersionInfo;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;

public class GoodDataSettings {
    private int maxConnections = 20;
    private int connectionTimeout = GoodDataSettings.secondsToMillis(10);
    private int connectionRequestTimeout = GoodDataSettings.secondsToMillis(10);
    private int socketTimeout = GoodDataSettings.secondsToMillis(60);
    private int pollSleep = GoodDataSettings.secondsToMillis(5);
    private String userAgent;
    private RetrySettings retrySettings;
    private Map<String, String> presetHeaders = new HashMap<String, String>(2);
    private static final String UNKNOWN_VERSION = "UNKNOWN";

    public GoodDataSettings() {
        this.presetHeaders.put("Accept", "application/json");
        this.presetHeaders.put("X-GDC-Version", GoodDataSettings.readApiVersion());
    }

    public void setMaxConnections(int maxConnections) {
        Assert.isTrue((maxConnections > 0 ? 1 : 0) != 0, (String)"maxConnections must be greater than zero");
        this.maxConnections = maxConnections;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        Assert.isTrue((connectionTimeout >= 0 ? 1 : 0) != 0, (String)"connectionTimeout must be not negative");
        this.connectionTimeout = connectionTimeout;
    }

    public void setConnectionTimeoutSeconds(int connectionTimeout) {
        this.setConnectionTimeout(GoodDataSettings.secondsToMillis(connectionTimeout));
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        Assert.isTrue((connectionRequestTimeout >= 0 ? 1 : 0) != 0, (String)"connectionRequestTimeout must not be negative");
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public void setConnectionRequestTimeoutSeconds(int connectionRequestTimeout) {
        this.setConnectionRequestTimeout(GoodDataSettings.secondsToMillis(connectionRequestTimeout));
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        Assert.isTrue((socketTimeout >= 0 ? 1 : 0) != 0, (String)"socketTimeout must be not negative");
        this.socketTimeout = socketTimeout;
    }

    public void setSocketTimeoutSeconds(int socketTimeout) {
        this.setSocketTimeout(GoodDataSettings.secondsToMillis(socketTimeout));
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getPollSleep() {
        return this.pollSleep;
    }

    public void setPollSleep(int pollSleep) {
        Assert.isTrue((pollSleep >= 0 ? 1 : 0) != 0, (String)"pollSleep must be not negative");
        this.pollSleep = pollSleep;
    }

    public void setPollSleepSeconds(int pollSleep) {
        this.setPollSleep(GoodDataSettings.secondsToMillis(pollSleep));
    }

    public String getGoodDataUserAgent() {
        return StringUtils.isNotBlank((CharSequence)this.userAgent) ? String.format("%s %s", this.userAgent, this.getDefaultUserAgent()) : this.getDefaultUserAgent();
    }

    public String getUserAgent() {
        return StringUtils.isNotBlank((CharSequence)this.userAgent) ? this.userAgent : this.getDefaultUserAgent();
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public RetrySettings getRetrySettings() {
        return this.retrySettings;
    }

    public void setRetrySettings(RetrySettings retrySettings) {
        this.retrySettings = retrySettings;
    }

    public void setPresetHeader(String header, String value) {
        this.presetHeaders.put((String)Validate.notNull((Object)header, (String)"header"), (String)Validate.notNull((Object)value, (String)"value"));
    }

    public Map<String, String> getPresetHeaders() {
        return this.presetHeaders;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoodDataSettings that = (GoodDataSettings)o;
        return this.maxConnections == that.maxConnections && this.connectionTimeout == that.connectionTimeout && this.connectionRequestTimeout == that.connectionRequestTimeout && this.socketTimeout == that.socketTimeout && this.pollSleep == that.pollSleep && Objects.equals(this.userAgent, that.userAgent) && Objects.equals(this.retrySettings, that.retrySettings) && Objects.equals(this.presetHeaders, that.presetHeaders);
    }

    public int hashCode() {
        return Objects.hash(this.maxConnections, this.connectionTimeout, this.connectionRequestTimeout, this.socketTimeout, this.pollSleep, this.userAgent, this.retrySettings, this.presetHeaders);
    }

    public String toString() {
        return GoodDataToStringBuilder.defaultToString((Object)this, (String[])new String[0]);
    }

    private static int secondsToMillis(int seconds) {
        return (int)TimeUnit.SECONDS.toMillis(seconds);
    }

    private String getDefaultUserAgent() {
        Package pkg = Package.getPackage("com.gooddata.sdk.service");
        String clientVersion = pkg != null && pkg.getImplementationVersion() != null ? pkg.getImplementationVersion() : UNKNOWN_VERSION;
        VersionInfo vi = VersionInfo.loadVersionInfo((String)"org.apache.http.client", (ClassLoader)HttpClientBuilder.class.getClassLoader());
        String apacheVersion = vi != null ? vi.getRelease() : UNKNOWN_VERSION;
        return String.format("%s/%s (%s; %s) %s/%s", "GoodData-Java-SDK", clientVersion, System.getProperty("os.name"), System.getProperty("java.specification.version"), "Apache-HttpClient", apacheVersion);
    }

    private static String readApiVersion() {
        try {
            return StreamUtils.copyToString((InputStream)GoodData.class.getResourceAsStream("/GoodDataApiVersion"), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot read GoodDataApiVersion from classpath", e);
        }
    }
}

