/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.dataload;

import com.gooddata.GoodDataException;
import com.gooddata.GoodDataRestException;
import com.gooddata.sdk.model.dataload.OutputStage;
import com.gooddata.sdk.model.project.Project;
import com.gooddata.sdk.service.AbstractService;
import com.gooddata.sdk.service.GoodDataSettings;
import com.gooddata.util.Validate;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplate;

public class OutputStageService
extends AbstractService {
    public static final UriTemplate OUTPUT_STAGE_TEMPLATE = new UriTemplate("/gdc/dataload/projects/{id}/outputStage");

    public OutputStageService(RestTemplate restTemplate, GoodDataSettings settings) {
        super(restTemplate, settings);
    }

    public OutputStage getOutputStageByUri(String uri) {
        Validate.notEmpty((CharSequence)uri, (String)"uri");
        Validate.isTrue((boolean)OUTPUT_STAGE_TEMPLATE.matches(uri), (String)("uri does not match output stage pattern: " + OUTPUT_STAGE_TEMPLATE.toString()));
        try {
            return (OutputStage)this.restTemplate.getForObject(uri, OutputStage.class, new Object[0]);
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get output stage " + uri, (Throwable)e);
        }
    }

    public OutputStage getOutputStage(Project project) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        return this.getOutputStageByUri(OUTPUT_STAGE_TEMPLATE.expand(new Object[]{project.getId()}).toString());
    }

    public OutputStage updateOutputStage(OutputStage outputStage) {
        Validate.notNull((Object)outputStage, (String)"outputStage");
        Validate.notNull((Object)outputStage.getUri(), (String)"outputStage.uri");
        try {
            HttpEntity outputStageHttpEntity = new HttpEntity((Object)outputStage);
            ResponseEntity response = this.restTemplate.exchange(outputStage.getUri(), HttpMethod.PUT, outputStageHttpEntity, OutputStage.class, new Object[0]);
            if (response.getBody() == null) {
                throw new RestClientException("unexpected response body");
            }
            return (OutputStage)response.getBody();
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new GoodDataException("Unable to update output stage, uri: " + outputStage.getUri());
        }
    }
}

