/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.dataload.processes;

import com.gooddata.GoodDataException;
import com.gooddata.GoodDataRestException;
import com.gooddata.collections.MultiPageList;
import com.gooddata.collections.Page;
import com.gooddata.collections.PageRequest;
import com.gooddata.collections.PageableList;
import com.gooddata.sdk.model.dataload.processes.AsyncTask;
import com.gooddata.sdk.model.dataload.processes.DataloadProcess;
import com.gooddata.sdk.model.dataload.processes.DataloadProcesses;
import com.gooddata.sdk.model.dataload.processes.ProcessExecution;
import com.gooddata.sdk.model.dataload.processes.ProcessExecutionDetail;
import com.gooddata.sdk.model.dataload.processes.ProcessExecutionTask;
import com.gooddata.sdk.model.dataload.processes.Schedule;
import com.gooddata.sdk.model.dataload.processes.ScheduleExecution;
import com.gooddata.sdk.model.dataload.processes.Schedules;
import com.gooddata.sdk.model.project.Project;
import com.gooddata.sdk.service.AbstractPollHandler;
import com.gooddata.sdk.service.AbstractService;
import com.gooddata.sdk.service.FutureResult;
import com.gooddata.sdk.service.GoodDataSettings;
import com.gooddata.sdk.service.PollResult;
import com.gooddata.sdk.service.SimplePollHandler;
import com.gooddata.sdk.service.account.AccountService;
import com.gooddata.sdk.service.dataload.processes.ProcessExecutionException;
import com.gooddata.sdk.service.dataload.processes.ProcessNotFoundException;
import com.gooddata.sdk.service.dataload.processes.ScheduleExecutionException;
import com.gooddata.sdk.service.dataload.processes.ScheduleNotFoundException;
import com.gooddata.sdk.service.gdc.DataStoreService;
import com.gooddata.sdk.service.util.ZipHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

public class ProcessService
extends AbstractService {
    public static final UriTemplate SCHEDULE_TEMPLATE = new UriTemplate("/gdc/projects/{projectId}/schedules/{scheduleId}");
    public static final UriTemplate PROCESS_TEMPLATE = new UriTemplate("/gdc/projects/{projectId}/dataload/processes/{processId}");
    public static final UriTemplate SCHEDULES_TEMPLATE = new UriTemplate("/gdc/projects/{projectId}/schedules");
    public static final UriTemplate PROCESSES_TEMPLATE = new UriTemplate("/gdc/projects/{projectId}/dataload/processes");
    public static final UriTemplate USER_PROCESSES_TEMPLATE = new UriTemplate("/gdc/account/profile/{id}/dataload/processes");
    private static final MediaType MEDIA_TYPE_ZIP = MediaType.parseMediaType((String)"application/zip");
    private static final long MAX_MULTIPART_SIZE = 0x100000L;
    private final AccountService accountService;
    private final DataStoreService dataStoreService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ProcessService(RestTemplate restTemplate, AccountService accountService, DataStoreService dataStoreService, GoodDataSettings settings) {
        super(restTemplate, settings);
        this.dataStoreService = dataStoreService;
        this.accountService = (AccountService)com.gooddata.util.Validate.notNull((Object)accountService, (String)"accountService");
    }

    public DataloadProcess createProcess(Project project, DataloadProcess process, File processData) {
        com.gooddata.util.Validate.notNull((Object)process, (String)"process");
        com.gooddata.util.Validate.notNull((Object)processData, (String)"processData");
        com.gooddata.util.Validate.notNull((Object)project, (String)"project");
        Validate.isTrue((process.getPath() == null ? 1 : 0) != 0, (String)"Process path has to be null, use processData argument. If you want to create process from appstore, use method createProcessFromAppstore()", (Object[])new Object[0]);
        return this.postProcess(process, processData, ProcessService.getProcessesUri(project));
    }

    public DataloadProcess createProcess(Project project, DataloadProcess process) {
        com.gooddata.util.Validate.notNull((Object)project, (String)"project");
        com.gooddata.util.Validate.notNull((Object)process, (String)"process");
        Validate.isTrue((process.getPath() == null ? 1 : 0) != 0, (String)"Process path has to be null. If you want to create process from appstore, use method createProcessFromAppstore()", (Object[])new Object[0]);
        return this.postProcess(process, ProcessService.getProcessesUri(project));
    }

    public FutureResult<DataloadProcess> createProcessFromAppstore(Project project, DataloadProcess process) {
        com.gooddata.util.Validate.notNull((Object)project, (String)"project");
        com.gooddata.util.Validate.notNull((Object)process, (String)"process");
        com.gooddata.util.Validate.notEmpty((CharSequence)process.getPath(), (String)"process path");
        return this.postProcess(process, ProcessService.getProcessesUri(project), HttpMethod.POST);
    }

    public DataloadProcess updateProcess(DataloadProcess process, File processData) {
        com.gooddata.util.Validate.notNull((Object)process, (String)"process");
        com.gooddata.util.Validate.notNull((Object)process.getUri(), (String)"process.uri");
        com.gooddata.util.Validate.notNull((Object)processData, (String)"processData");
        Validate.isTrue((process.getPath() == null ? 1 : 0) != 0, (String)"Process path has to be null, use processData argument. If you want to update process from appstore, use method updateProcessFromAppstore()", (Object[])new Object[0]);
        return this.postProcess(process, processData, URI.create(process.getUri()));
    }

    public FutureResult<DataloadProcess> updateProcessFromAppstore(DataloadProcess process) {
        com.gooddata.util.Validate.notNull((Object)process, (String)"process");
        com.gooddata.util.Validate.notNull((Object)process.getUri(), (String)"process.uri");
        com.gooddata.util.Validate.notEmpty((CharSequence)process.getPath(), (String)"process path must not be empty");
        return this.postProcess(process, URI.create(process.getUri()), HttpMethod.PUT);
    }

    public DataloadProcess getProcessByUri(String uri) {
        com.gooddata.util.Validate.notEmpty((CharSequence)uri, (String)"uri");
        try {
            return (DataloadProcess)this.restTemplate.getForObject(uri, DataloadProcess.class, new Object[0]);
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new ProcessNotFoundException(uri, e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get process " + uri, (Throwable)e);
        }
    }

    public DataloadProcess getProcessById(Project project, String id) {
        com.gooddata.util.Validate.notEmpty((CharSequence)id, (String)"id");
        com.gooddata.util.Validate.notNull((Object)project, (String)"project");
        return this.getProcessByUri(ProcessService.getProcessUri(project, id).toString());
    }

    public Collection<DataloadProcess> listProcesses(Project project) {
        com.gooddata.util.Validate.notNull((Object)project, (String)"project");
        return this.listProcesses(ProcessService.getProcessesUri(project));
    }

    public Collection<DataloadProcess> listUserProcesses() {
        return this.listProcesses(USER_PROCESSES_TEMPLATE.expand(new Object[]{this.accountService.getCurrent().getId()}));
    }

    public void removeProcess(DataloadProcess process) {
        com.gooddata.util.Validate.notNull((Object)process, (String)"process");
        try {
            this.restTemplate.delete(process.getUri(), new Object[0]);
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to remove process " + process.getUri(), e);
        }
    }

    public void getProcessSource(DataloadProcess process, OutputStream outputStream) {
        com.gooddata.util.Validate.notNull((Object)process, (String)"process");
        com.gooddata.util.Validate.notNull((Object)outputStream, (String)"outputStream");
        try {
            this.restTemplate.execute(process.getSourceUri(), HttpMethod.GET, null, (ResponseExtractor)new AbstractService.OutputStreamResponseExtractor(outputStream), new Object[0]);
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to get process source " + process.getSourceUri(), e);
        }
    }

    public void getExecutionLog(ProcessExecutionDetail executionDetail, OutputStream outputStream) {
        com.gooddata.util.Validate.notNull((Object)executionDetail, (String)"executionDetail");
        com.gooddata.util.Validate.notNull((Object)outputStream, (String)"outputStream");
        try {
            this.restTemplate.execute(executionDetail.getLogUri(), HttpMethod.GET, null, (ResponseExtractor)new AbstractService.OutputStreamResponseExtractor(outputStream), new Object[0]);
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to get process execution log " + executionDetail.getLogUri(), e);
        }
    }

    public FutureResult<ProcessExecutionDetail> executeProcess(ProcessExecution execution) {
        ProcessExecutionTask executionTask;
        com.gooddata.util.Validate.notNull((Object)execution, (String)"execution");
        try {
            executionTask = (ProcessExecutionTask)this.restTemplate.postForObject(execution.getExecutionsUri(), (Object)execution, ProcessExecutionTask.class, new Object[0]);
        }
        catch (GoodDataException | RestClientException e) {
            throw new ProcessExecutionException("Cannot execute process", e);
        }
        if (executionTask == null) {
            throw new ProcessExecutionException("Cannot find started execution.");
        }
        final String detailLink = executionTask.getDetailUri();
        return new PollResult<ProcessExecutionDetail>(this, new AbstractPollHandler<Void, ProcessExecutionDetail>(executionTask.getPollUri(), Void.class, ProcessExecutionDetail.class){

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                return HttpStatus.NO_CONTENT.equals((Object)response.getStatusCode());
            }

            @Override
            public void handlePollResult(Void pollResult) {
                ProcessExecutionDetail executionDetail = this.getProcessExecutionDetailByUri(detailLink);
                if (!executionDetail.isSuccess()) {
                    throw new ProcessExecutionException("Execution was not successful", executionDetail);
                }
                this.setResult(executionDetail);
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                ProcessExecutionDetail detail = null;
                try {
                    detail = this.getProcessExecutionDetailByUri(detailLink);
                }
                catch (GoodDataException goodDataException) {
                    // empty catch block
                }
                throw new ProcessExecutionException("Can't execute " + e.getText(), detail, e);
            }

            private ProcessExecutionDetail getProcessExecutionDetailByUri(String uri) {
                try {
                    return (ProcessExecutionDetail)ProcessService.this.restTemplate.getForObject(uri, ProcessExecutionDetail.class, new Object[0]);
                }
                catch (GoodDataException | RestClientException e) {
                    throw new ProcessExecutionException("Execution finished, but cannot get its result.", e, uri);
                }
            }
        });
    }

    public Schedule createSchedule(Project project, Schedule schedule) {
        com.gooddata.util.Validate.notNull((Object)schedule, (String)"schedule");
        com.gooddata.util.Validate.notNull((Object)project, (String)"project");
        return this.postSchedule(schedule, ProcessService.getSchedulesUri(project));
    }

    public Schedule updateSchedule(Schedule schedule) {
        com.gooddata.util.Validate.notNull((Object)schedule, (String)"schedule");
        com.gooddata.util.Validate.notNull((Object)schedule.getUri(), (String)"schedule.uri");
        String uri = schedule.getUri();
        try {
            ResponseEntity response = this.restTemplate.exchange(uri, HttpMethod.PUT, new HttpEntity((Object)schedule), Schedule.class, new Object[0]);
            if (response == null) {
                throw new GoodDataException("Unable to update schedule. No response returned from API.");
            }
            return (Schedule)response.getBody();
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new ScheduleNotFoundException(uri, e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get schedule " + uri, (Throwable)e);
        }
    }

    public Schedule getScheduleByUri(String uri) {
        com.gooddata.util.Validate.notEmpty((CharSequence)uri, (String)"uri");
        try {
            return (Schedule)this.restTemplate.getForObject(uri, Schedule.class, new Object[0]);
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.NOT_FOUND.value() == e.getStatusCode()) {
                throw new ScheduleNotFoundException(uri, e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get schedule " + uri, (Throwable)e);
        }
    }

    public Schedule getScheduleById(Project project, String id) {
        com.gooddata.util.Validate.notEmpty((CharSequence)id, (String)"id");
        com.gooddata.util.Validate.notNull((Object)project, (String)"project");
        return this.getScheduleByUri(ProcessService.getScheduleUri(project, id).toString());
    }

    public PageableList<Schedule> listSchedules(Project project) {
        return this.listSchedules(project, (Page)new PageRequest());
    }

    public PageableList<Schedule> listSchedules(Project project, Page startPage) {
        com.gooddata.util.Validate.notNull((Object)project, (String)"project");
        com.gooddata.util.Validate.notNull((Object)startPage, (String)"startPage");
        return new MultiPageList(startPage, page -> this.listSchedules(ProcessService.getSchedulesUri(project, page)));
    }

    public void removeSchedule(Schedule schedule) {
        com.gooddata.util.Validate.notNull((Object)schedule, (String)"schedule");
        com.gooddata.util.Validate.notNull((Object)schedule.getUri(), (String)"schedule.uri");
        try {
            this.restTemplate.delete(schedule.getUri(), new Object[0]);
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to remove schedule " + schedule.getUri(), e);
        }
    }

    public FutureResult<ScheduleExecution> executeSchedule(Schedule schedule) {
        ScheduleExecution scheduleExecution;
        com.gooddata.util.Validate.notNull((Object)schedule, (String)"schedule");
        com.gooddata.util.Validate.notNull((Object)schedule.getExecutionsUri(), (String)"schedule.executionsUri");
        try {
            scheduleExecution = (ScheduleExecution)this.restTemplate.postForObject(schedule.getExecutionsUri(), (Object)new ScheduleExecution(), ScheduleExecution.class, new Object[0]);
        }
        catch (GoodDataException | RestClientException e) {
            throw new ScheduleExecutionException("Cannot execute schedule", e);
        }
        return new PollResult<ScheduleExecution>(this, new AbstractPollHandler<ScheduleExecution, ScheduleExecution>(scheduleExecution.getUri(), ScheduleExecution.class, ScheduleExecution.class){

            @Override
            public boolean isFinished(ClientHttpResponse response) throws IOException {
                ScheduleExecution pollResult = (ScheduleExecution)ProcessService.this.extractData(response, ScheduleExecution.class);
                return pollResult.isFinished();
            }

            @Override
            public void handlePollResult(ScheduleExecution pollResult) {
                this.setResult(pollResult);
            }

            @Override
            public void handlePollException(GoodDataRestException e) {
                throw new ScheduleExecutionException("Cannot execute schedule", e);
            }
        });
    }

    private PageableList<Schedule> listSchedules(URI uri) {
        try {
            Schedules schedules = (Schedules)this.restTemplate.getForObject(uri, Schedules.class);
            if (schedules == null) {
                return new PageableList();
            }
            return schedules;
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list schedules", e);
        }
    }

    private static URI getScheduleUri(Project project, String id) {
        com.gooddata.util.Validate.notNull((Object)project, (String)"project");
        com.gooddata.util.Validate.notNull((Object)project.getId(), (String)"project.id");
        com.gooddata.util.Validate.notEmpty((CharSequence)id, (String)"id");
        return SCHEDULE_TEMPLATE.expand(new Object[]{project.getId(), id});
    }

    private static URI getSchedulesUri(Project project) {
        com.gooddata.util.Validate.notNull((Object)project, (String)"project");
        com.gooddata.util.Validate.notNull((Object)project.getId(), (String)"project.id");
        return SCHEDULES_TEMPLATE.expand(new Object[]{project.getId()});
    }

    private static URI getSchedulesUri(Project project, Page page) {
        return page.getPageUri(UriComponentsBuilder.fromUri((URI)ProcessService.getSchedulesUri(project)));
    }

    private Schedule postSchedule(Schedule schedule, URI postUri) {
        try {
            return (Schedule)this.restTemplate.postForObject(postUri, (Object)schedule, Schedule.class);
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to post schedule.", e);
        }
    }

    private Collection<DataloadProcess> listProcesses(URI uri) {
        try {
            DataloadProcesses processes = (DataloadProcesses)this.restTemplate.getForObject(uri, DataloadProcesses.class);
            if (processes == null) {
                throw new GoodDataException("empty response from API call");
            }
            if (processes.getItems() == null) {
                return Collections.emptyList();
            }
            return processes.getItems();
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list processes", e);
        }
    }

    private static URI getProcessUri(Project project, String id) {
        com.gooddata.util.Validate.notNull((Object)project, (String)"project");
        com.gooddata.util.Validate.notNull((Object)project.getId(), (String)"project.id");
        com.gooddata.util.Validate.notEmpty((CharSequence)id, (String)"id");
        return PROCESS_TEMPLATE.expand(new Object[]{project.getId(), id});
    }

    private static URI getProcessesUri(Project project) {
        return PROCESSES_TEMPLATE.expand(new Object[]{project.getId()});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DataloadProcess postProcess(DataloadProcess process, File processData, URI postUri) {
        DataloadProcess processToSend;
        Throwable throwable;
        HttpMethod method;
        File tempFile;
        block38: {
            tempFile = this.createTempFile("process", ".zip");
            try (OutputStream output = Files.newOutputStream(tempFile.toPath(), new OpenOption[0]);){
                ZipHelper.zip(processData, output);
            }
            catch (IOException e) {
                throw new GoodDataException("Unable to zip process data", (Throwable)e);
            }
            method = HttpMethod.POST;
            if (this.dataStoreService != null && tempFile.length() > 0x100000L) {
                try {
                    throwable = null;
                    try (InputStream input = Files.newInputStream(tempFile.toPath(), new OpenOption[0]);){
                        process.setPath(this.dataStoreService.getUri(tempFile.getName()).getPath());
                        this.dataStoreService.upload(tempFile.getName(), input);
                        processToSend = process;
                        if (PROCESS_TEMPLATE.matches(postUri.toString())) {
                            method = HttpMethod.PUT;
                        }
                        break block38;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (IOException e) {
                    throw new GoodDataException("Unable to access zipped process data at " + tempFile.getAbsolutePath(), (Throwable)e);
                }
            }
            if (this.dataStoreService == null && this.logger.isInfoEnabled()) {
                this.logger.info("WebDAV calls not supported - sending huge file using multipart. Consider adding com.github.lookfirst:sardine to dependencies.");
            }
            LinkedMultiValueMap parts = new LinkedMultiValueMap(2);
            parts.add((Object)"process", (Object)process);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MEDIA_TYPE_ZIP);
            parts.add((Object)"data", (Object)new HttpEntity((Object)new FileSystemResource(tempFile), (MultiValueMap)headers));
            processToSend = parts;
        }
        try {
            ResponseEntity response = this.restTemplate.exchange(postUri, method, new HttpEntity((Object)processToSend), DataloadProcess.class);
            if (response == null) {
                throw new GoodDataException("Unable to post dataload process. No response returned from API.");
            }
            throwable = (DataloadProcess)response.getBody();
            return throwable;
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to post dataload process.", e);
        }
        finally {
            this.deleteTempFile(tempFile);
        }
    }

    private FutureResult<DataloadProcess> postProcess(DataloadProcess process, URI postUri, HttpMethod method) {
        try {
            ResponseEntity exchange = this.restTemplate.exchange(postUri, method, new HttpEntity((Object)process), String.class);
            if (exchange.getStatusCode() == HttpStatus.ACCEPTED) {
                AsyncTask asyncTask = (AsyncTask)this.mapper.readValue((String)exchange.getBody(), AsyncTask.class);
                return new PollResult<DataloadProcess>(this, new SimplePollHandler<DataloadProcess>(asyncTask.getUri(), DataloadProcess.class){

                    @Override
                    public void handlePollException(GoodDataRestException e) {
                        throw new GoodDataException("Creating process failed", (Throwable)e);
                    }
                });
            }
            if (exchange.getStatusCode() == HttpStatus.OK) {
                DataloadProcess dataloadProcess = (DataloadProcess)this.mapper.readValue((String)exchange.getBody(), DataloadProcess.class);
                return new PollResult<DataloadProcess>(this, new SimplePollHandler<DataloadProcess>(dataloadProcess.getUri(), DataloadProcess.class){

                    @Override
                    public void handlePollException(GoodDataRestException e) {
                        throw new GoodDataException("Creating process failed", (Throwable)e);
                    }
                });
            }
            throw new IllegalStateException("Unexpected status code from resource: " + exchange.getStatusCode());
        }
        catch (IOException | RestClientException e) {
            throw new GoodDataException("Creating process failed", e);
        }
    }

    private DataloadProcess postProcess(DataloadProcess process, URI postUri) {
        try {
            return (DataloadProcess)this.restTemplate.postForObject(postUri, (Object)process, DataloadProcess.class);
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to create dataload process.", e);
        }
    }

    private File createTempFile(String prefix, String suffix) {
        File tempFile;
        try {
            tempFile = File.createTempFile(prefix, suffix);
            tempFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new GoodDataException("Unable to create temporary file", (Throwable)e);
        }
        return tempFile;
    }

    private void deleteTempFile(File file) {
        com.gooddata.util.Validate.notNull((Object)file, (String)"file");
        if (!file.delete()) {
            // empty if block
        }
    }
}

