/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.lcm;

import com.gooddata.GoodDataException;
import com.gooddata.collections.MultiPageList;
import com.gooddata.collections.Page;
import com.gooddata.collections.PageRequest;
import com.gooddata.collections.PageableList;
import com.gooddata.sdk.model.account.Account;
import com.gooddata.sdk.model.lcm.LcmEntities;
import com.gooddata.sdk.model.lcm.LcmEntity;
import com.gooddata.sdk.model.lcm.LcmEntityFilter;
import com.gooddata.sdk.service.AbstractService;
import com.gooddata.sdk.service.GoodDataSettings;
import com.gooddata.util.Validate;
import java.net.URI;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

public class LcmService
extends AbstractService {
    public static final UriTemplate LCM_ENTITIES_TEMPLATE = new UriTemplate("/gdc/account/profile/{profileId}/lcmEntities");

    public LcmService(RestTemplate restTemplate, GoodDataSettings settings) {
        super(restTemplate, settings);
    }

    public PageableList<LcmEntity> listLcmEntities(Account account) {
        return this.listLcmEntities(account, (Page)new PageRequest());
    }

    public PageableList<LcmEntity> listLcmEntities(Account account, LcmEntityFilter filter) {
        return this.listLcmEntities(account, filter, (Page)new PageRequest());
    }

    public PageableList<LcmEntity> listLcmEntities(Account account, Page startPage) {
        return this.listLcmEntities(account, new LcmEntityFilter(), startPage);
    }

    public PageableList<LcmEntity> listLcmEntities(Account account, LcmEntityFilter filter, Page startPage) {
        Validate.notNull((Object)filter, (String)"filter");
        Validate.notNull((Object)startPage, (String)"startPage");
        String accountId = ((Account)Validate.notNull((Object)account, (String)"account")).getId();
        return new MultiPageList(startPage, page -> this.listLcmEntities(this.getLcmEntitiesUri(accountId, filter, (Page)page)));
    }

    private URI getLcmEntitiesUri(String accountId) {
        return LCM_ENTITIES_TEMPLATE.expand(new Object[]{accountId});
    }

    private URI getLcmEntitiesUri(String accountId, LcmEntityFilter filter, Page page) {
        return page.getPageUri(UriComponentsBuilder.fromUri((URI)this.getLcmEntitiesUri(accountId)).queryParams((MultiValueMap)new LinkedMultiValueMap(filter.asQueryParams())));
    }

    private PageableList<LcmEntity> listLcmEntities(URI uri) {
        try {
            LcmEntities result = (LcmEntities)this.restTemplate.getForObject(uri, LcmEntities.class);
            if (result == null) {
                return new PageableList();
            }
            return result;
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list LcmEntity", e);
        }
    }
}

