/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service;

import com.gooddata.util.Validate;
import org.apache.http.HttpHost;

public class GoodDataEndpoint {
    public static final String PROTOCOL = "https";
    public static final int PORT = 443;
    public static final String HOSTNAME = "secure.gooddata.com";
    private final String hostname;
    private final int port;
    private final String protocol;

    public GoodDataEndpoint(String hostname, int port, String protocol) {
        this.hostname = (String)Validate.notEmpty((CharSequence)hostname, (String)"hostname");
        this.port = port;
        this.protocol = (String)Validate.notEmpty((CharSequence)protocol, (String)"protocol");
    }

    public GoodDataEndpoint(String hostname, int port) {
        this(hostname, port, PROTOCOL);
    }

    public GoodDataEndpoint(String hostname) {
        this(hostname, 443, PROTOCOL);
    }

    public GoodDataEndpoint() {
        this(HOSTNAME, 443, PROTOCOL);
    }

    public String toUri() {
        return new HttpHost(this.hostname, this.port, this.protocol).toURI();
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }
}

