/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.retry;

import com.gooddata.GoodDataRestException;
import com.gooddata.sdk.service.retry.GetServerErrorRetryStrategy;
import com.gooddata.sdk.service.retry.RetrySettings;
import com.gooddata.sdk.service.retry.RetryStrategy;
import java.net.URI;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class RetryableRestTemplate
extends RestTemplate {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final RetryTemplate retryTemplate;
    private final RetryStrategy retryStrategy;

    public RetryableRestTemplate(ClientHttpRequestFactory requestFactory, RetryTemplate retryTemplate, RetryStrategy retryStrategy) {
        super(requestFactory);
        Validate.notNull((Object)retryTemplate);
        this.retryTemplate = retryTemplate;
        this.retryStrategy = retryStrategy;
    }

    protected <T> T doExecute(URI url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        return (T)this.retryTemplate.execute(context -> {
            try {
                return super.doExecute(url, method, requestCallback, responseExtractor);
            }
            catch (GoodDataRestException e) {
                if (!this.retryStrategy.retryAllowed(method.toString(), e.getStatusCode(), url)) {
                    context.setExhaustedOnly();
                } else {
                    int retryCount = context.getRetryCount();
                    this.logger.info("{}call of {} {} failed, HTTP {} and will be retried, {} ", new Object[]{retryCount == 0 ? "" : retryCount + " ", method, url, e.getStatusCode(), e.getMessage()});
                }
                throw e;
            }
        });
    }

    public static RestTemplate create(RetrySettings retrySettings, ClientHttpRequestFactory factory) {
        RetryTemplate retryTemplate = new RetryTemplate();
        if (retrySettings.getRetryCount() != null) {
            retryTemplate.setRetryPolicy((RetryPolicy)new SimpleRetryPolicy(retrySettings.getRetryCount().intValue()));
        }
        if (retrySettings.getRetryInitialInterval() != null) {
            if (retrySettings.getRetryMultiplier() != null) {
                ExponentialBackOffPolicy exponentialBackOffPolicy = new ExponentialBackOffPolicy();
                exponentialBackOffPolicy.setInitialInterval(retrySettings.getRetryInitialInterval().longValue());
                exponentialBackOffPolicy.setMultiplier(retrySettings.getRetryMultiplier().doubleValue());
                exponentialBackOffPolicy.setMaxInterval(retrySettings.getRetryMaxInterval().longValue());
                retryTemplate.setBackOffPolicy((BackOffPolicy)exponentialBackOffPolicy);
            } else {
                FixedBackOffPolicy backOffPolicy = new FixedBackOffPolicy();
                backOffPolicy.setBackOffPeriod(retrySettings.getRetryInitialInterval().longValue());
                retryTemplate.setBackOffPolicy((BackOffPolicy)backOffPolicy);
            }
        }
        return new RetryableRestTemplate(factory, retryTemplate, new GetServerErrorRetryStrategy());
    }
}

