/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.httpcomponents;

import com.gooddata.http.client.GoodDataHttpClient;
import com.gooddata.http.client.LoginSSTRetrievalStrategy;
import com.gooddata.http.client.SSTRetrievalStrategy;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.service.GoodDataEndpoint;
import com.gooddata.sdk.service.GoodDataSettings;
import com.gooddata.sdk.service.httpcomponents.SingleEndpointGoodDataRestProvider;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public final class LoginPasswordGoodDataRestProvider
extends SingleEndpointGoodDataRestProvider {
    public LoginPasswordGoodDataRestProvider(GoodDataEndpoint endpoint, GoodDataSettings settings, String login, String password) {
        super(endpoint, settings, (builder, builderEndpoint, builderSettings) -> LoginPasswordGoodDataRestProvider.createHttpClient(builder, builderEndpoint, login, password));
    }

    public static HttpClient createHttpClient(HttpClientBuilder builder, GoodDataEndpoint endpoint, String login, String password) {
        Validate.notNull((Object)endpoint, (String)"endpoint");
        Validate.notNull((Object)builder, (String)"builder");
        Validate.notNull((Object)login, (String)"login");
        Validate.notNull((Object)password, (String)"password");
        CloseableHttpClient httpClient = builder.build();
        LoginSSTRetrievalStrategy strategy = new LoginSSTRetrievalStrategy(login, password);
        HttpHost httpHost = new HttpHost(endpoint.getHostname(), endpoint.getPort(), endpoint.getProtocol());
        return new GoodDataHttpClient((HttpClient)httpClient, httpHost, (SSTRetrievalStrategy)strategy);
    }
}

