/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service;

import com.gooddata.sdk.common.util.Validate;
import java.io.IOException;
import java.util.Map;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.support.HttpRequestWrapper;

public class HeaderSettingRequestInterceptor
implements ClientHttpRequestInterceptor {
    private final Map<String, String> headers;

    public HeaderSettingRequestInterceptor(Map<String, String> headers) {
        this.headers = (Map)Validate.notNull(headers, (String)"headers");
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        HttpRequestWrapper requestWrapper = new HttpRequestWrapper(request);
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            requestWrapper.getHeaders().set(header.getKey(), header.getValue());
        }
        return execution.execute((HttpRequest)requestWrapper, body);
    }
}

