/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.featureflag;

import com.gooddata.sdk.common.GoodDataException;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.model.featureflag.FeatureFlags;
import com.gooddata.sdk.model.featureflag.ProjectFeatureFlag;
import com.gooddata.sdk.model.featureflag.ProjectFeatureFlags;
import com.gooddata.sdk.model.project.Project;
import com.gooddata.sdk.service.AbstractService;
import com.gooddata.sdk.service.GoodDataSettings;
import java.net.URI;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplate;

public class FeatureFlagService
extends AbstractService {
    public static final UriTemplate PROJECT_FEATURE_FLAG_TEMPLATE = new UriTemplate("/gdc/projects/{id}/projectFeatureFlags/{featureFlag}");
    public static final UriTemplate PROJECT_FEATURE_FLAGS_TEMPLATE = new UriTemplate("/gdc/projects/{id}/projectFeatureFlags");
    public static final UriTemplate AGGREGATED_FEATURE_FLAGS_TEMPLATE = new UriTemplate("/gdc/internal/projects/{projectId}/featureFlags");

    public FeatureFlagService(RestTemplate restTemplate, GoodDataSettings settings) {
        super(restTemplate, settings);
    }

    public FeatureFlags listFeatureFlags(Project project) {
        Validate.notNull((Object)project, (String)"project");
        try {
            FeatureFlags featureFlags = (FeatureFlags)this.restTemplate.getForObject(AGGREGATED_FEATURE_FLAGS_TEMPLATE.expand(new Object[]{project.getId()}), FeatureFlags.class);
            if (featureFlags == null) {
                throw new GoodDataException("empty response from API call");
            }
            return featureFlags;
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list aggregated feature flags for project ID=" + project.getId(), e);
        }
    }

    public ProjectFeatureFlags listProjectFeatureFlags(Project project) {
        Validate.notNull((Object)project, (String)"project");
        try {
            ProjectFeatureFlags projectFeatureFlags = (ProjectFeatureFlags)this.restTemplate.getForObject(PROJECT_FEATURE_FLAGS_TEMPLATE.expand(new Object[]{project.getId()}), ProjectFeatureFlags.class);
            if (projectFeatureFlags == null) {
                throw new GoodDataException("empty response from API call");
            }
            return projectFeatureFlags;
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list project feature flags for project ID=" + project.getId(), e);
        }
    }

    public ProjectFeatureFlag getProjectFeatureFlag(Project project, String featureFlagName) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notEmpty((CharSequence)featureFlagName, (String)"featureFlagName");
        try {
            ProjectFeatureFlag flag = this.getProjectFeatureFlag(this.getProjectFeatureFlagUri(project, featureFlagName));
            if (flag == null) {
                throw new GoodDataException("empty response from API call");
            }
            return flag;
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to get project feature flag: " + featureFlagName, e);
        }
    }

    public ProjectFeatureFlag createProjectFeatureFlag(Project project, ProjectFeatureFlag flag) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)flag, (String)"flag");
        String featureFlagsUri = PROJECT_FEATURE_FLAGS_TEMPLATE.expand(new Object[]{project.getId()}).toString();
        try {
            URI featureFlagUri = this.restTemplate.postForLocation(featureFlagsUri, (Object)flag, new Object[0]);
            if (featureFlagUri == null) {
                throw new GoodDataException("URI of new project feature flag can't be null");
            }
            return this.getProjectFeatureFlag(featureFlagUri.toString());
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to create project feature flag: " + flag, e);
        }
    }

    public ProjectFeatureFlag updateProjectFeatureFlag(ProjectFeatureFlag flag) {
        Validate.notNull((Object)flag, (String)"flag");
        Validate.notEmpty((CharSequence)flag.getUri(), (String)"flag.uri");
        try {
            this.restTemplate.put(flag.getUri(), (Object)flag, new Object[0]);
            return this.getProjectFeatureFlag(flag.getUri());
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to update project feature flag: " + flag, e);
        }
    }

    public void deleteProjectFeatureFlag(ProjectFeatureFlag flag) {
        Validate.notNull((Object)flag, (String)"flag");
        Validate.notEmpty((CharSequence)flag.getUri(), (String)"flag URI");
        try {
            this.restTemplate.delete(flag.getUri(), new Object[0]);
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to delete project feature flag: " + flag, e);
        }
    }

    String getProjectFeatureFlagUri(Project project, String flagName) {
        return PROJECT_FEATURE_FLAG_TEMPLATE.expand(new Object[]{project.getId(), flagName}).toString();
    }

    private ProjectFeatureFlag getProjectFeatureFlag(String flagUri) {
        ProjectFeatureFlag result = (ProjectFeatureFlag)this.restTemplate.getForObject(flagUri, ProjectFeatureFlag.class, new Object[0]);
        if (result == null) {
            throw new GoodDataException("Project feature flag cannot be retrieved from URI " + flagUri);
        }
        return result;
    }
}

