/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.lcm;

import com.gooddata.sdk.common.GoodDataException;
import com.gooddata.sdk.common.collections.CustomPageRequest;
import com.gooddata.sdk.common.collections.Page;
import com.gooddata.sdk.common.collections.PageBrowser;
import com.gooddata.sdk.common.collections.PageRequest;
import com.gooddata.sdk.common.util.MutableUri;
import com.gooddata.sdk.common.util.SpringMutableUri;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.model.account.Account;
import com.gooddata.sdk.model.lcm.LcmEntities;
import com.gooddata.sdk.model.lcm.LcmEntity;
import com.gooddata.sdk.model.lcm.LcmEntityFilter;
import com.gooddata.sdk.service.AbstractService;
import com.gooddata.sdk.service.GoodDataSettings;
import java.net.URI;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplate;

public class LcmService
extends AbstractService {
    public static final UriTemplate LCM_ENTITIES_TEMPLATE = new UriTemplate("/gdc/account/profile/{profileId}/lcmEntities");

    public LcmService(RestTemplate restTemplate, GoodDataSettings settings) {
        super(restTemplate, settings);
    }

    public PageBrowser<LcmEntity> listLcmEntities(Account account) {
        return this.listLcmEntities(account, (PageRequest)new CustomPageRequest());
    }

    public PageBrowser<LcmEntity> listLcmEntities(Account account, LcmEntityFilter filter) {
        return this.listLcmEntities(account, filter, (PageRequest)new CustomPageRequest());
    }

    public PageBrowser<LcmEntity> listLcmEntities(Account account, PageRequest startPage) {
        return this.listLcmEntities(account, new LcmEntityFilter(), startPage);
    }

    public PageBrowser<LcmEntity> listLcmEntities(Account account, LcmEntityFilter filter, PageRequest startPage) {
        Validate.notNull((Object)filter, (String)"filter");
        Validate.notNull((Object)startPage, (String)"startPage");
        String accountId = ((Account)Validate.notNull((Object)account, (String)"account")).getId();
        return new PageBrowser(startPage, page -> this.listLcmEntities(this.getLcmEntitiesUri(accountId, filter, (PageRequest)page)));
    }

    private URI getLcmEntitiesUri(String accountId) {
        return LCM_ENTITIES_TEMPLATE.expand(new Object[]{accountId});
    }

    private URI getLcmEntitiesUri(String accountId, LcmEntityFilter filter, PageRequest page) {
        SpringMutableUri mutableUri = new SpringMutableUri(this.getLcmEntitiesUri(accountId));
        mutableUri.replaceQueryParams((MultiValueMap)new LinkedMultiValueMap(filter.asQueryParams()));
        return page.getPageUri((MutableUri)mutableUri);
    }

    private Page<LcmEntity> listLcmEntities(URI uri) {
        try {
            LcmEntities result = (LcmEntities)this.restTemplate.getForObject(uri, LcmEntities.class);
            if (result == null) {
                return new Page();
            }
            return result;
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list LcmEntity", e);
        }
    }
}

