/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.auditevent;

import com.gooddata.sdk.common.GoodDataException;
import com.gooddata.sdk.common.GoodDataRestException;
import com.gooddata.sdk.common.collections.PageBrowser;
import com.gooddata.sdk.common.collections.PageRequest;
import com.gooddata.sdk.common.util.MutableUri;
import com.gooddata.sdk.common.util.SpringMutableUri;
import com.gooddata.sdk.common.util.Validate;
import com.gooddata.sdk.model.account.Account;
import com.gooddata.sdk.model.auditevent.AuditEvent;
import com.gooddata.sdk.model.auditevent.AuditEvents;
import com.gooddata.sdk.service.AbstractService;
import com.gooddata.sdk.service.GoodDataSettings;
import com.gooddata.sdk.service.account.AccountService;
import com.gooddata.sdk.service.auditevent.AuditEventPageRequest;
import com.gooddata.sdk.service.auditevent.AuditEventsForbiddenException;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplate;

public class AuditEventService
extends AbstractService {
    public static final UriTemplate ADMIN_URI_TEMPLATE = new UriTemplate("/gdc/domains/{domainId}/auditEvents");
    public static final UriTemplate USER_URI_TEMPLATE = new UriTemplate("/gdc/account/profile/{userId}/auditEvents");
    private final AccountService accountService;

    public AuditEventService(RestTemplate restTemplate, AccountService accountService, GoodDataSettings settings) {
        super(restTemplate, settings);
        this.accountService = (AccountService)Validate.notNull((Object)accountService, (String)"account service");
    }

    public PageBrowser<AuditEvent> listAuditEvents(String domainId) {
        return this.listAuditEvents(domainId, (PageRequest)new AuditEventPageRequest());
    }

    public PageBrowser<AuditEvent> listAuditEvents(String domainId, PageRequest page) {
        Validate.notEmpty((CharSequence)domainId, (String)"domainId");
        Validate.notNull((Object)page, (String)"page");
        String uri = ADMIN_URI_TEMPLATE.expand(new Object[]{domainId}).toString();
        return new PageBrowser(page, p -> this.doListAuditEvents(this.getAuditEventsUri((PageRequest)p, uri)));
    }

    public PageBrowser<AuditEvent> listAuditEvents(Account account) {
        return this.listAuditEvents(account, (PageRequest)new AuditEventPageRequest());
    }

    public PageBrowser<AuditEvent> listAuditEvents(Account account, PageRequest page) {
        Validate.notNull((Object)account, (String)"account");
        Validate.notEmpty((CharSequence)account.getId(), (String)"account.id");
        Validate.notNull((Object)page, (String)"page");
        String uri = USER_URI_TEMPLATE.expand(new Object[]{account.getId()}).toString();
        return new PageBrowser(page, p -> this.doListAuditEvents(this.getAuditEventsUri((PageRequest)p, uri)));
    }

    public PageBrowser<AuditEvent> listAuditEvents() {
        return this.listAuditEvents((PageRequest)new AuditEventPageRequest());
    }

    public PageBrowser<AuditEvent> listAuditEvents(PageRequest page) {
        Validate.notNull((Object)page, (String)"page");
        Account account = this.accountService.getCurrent();
        return this.listAuditEvents(account, page);
    }

    private AuditEvents doListAuditEvents(String uri) {
        try {
            return (AuditEvents)this.restTemplate.getForObject(uri, AuditEvents.class, new Object[0]);
        }
        catch (GoodDataRestException e) {
            if (HttpStatus.UNAUTHORIZED.value() == e.getStatusCode()) {
                throw new AuditEventsForbiddenException(e);
            }
            throw e;
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to list audit events: " + uri);
        }
    }

    private String getAuditEventsUri(PageRequest page, String uri) {
        return page.updateWithPageParams((MutableUri)new SpringMutableUri(uri)).toUriString();
    }
}

