/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpResponse;

class HttpClient4ComponentsClientHttpResponse
implements ClientHttpResponse {
    private final HttpResponse httpResponse;
    private HttpHeaders headers;

    public HttpClient4ComponentsClientHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public HttpStatusCode getStatusCode() throws IOException {
        return HttpStatusCode.valueOf((int)this.httpResponse.getStatusLine().getStatusCode());
    }

    public int getRawStatusCode() throws IOException {
        return this.httpResponse.getStatusLine().getStatusCode();
    }

    public String getStatusText() throws IOException {
        return this.httpResponse.getStatusLine().getReasonPhrase();
    }

    public HttpHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = new HttpHeaders();
            for (Header header : this.httpResponse.getAllHeaders()) {
                this.headers.add(header.getName(), header.getValue());
            }
        }
        return this.headers;
    }

    public InputStream getBody() throws IOException {
        HttpEntity entity = this.httpResponse.getEntity();
        return entity != null ? entity.getContent() : new ByteArrayInputStream(new byte[0]);
    }

    public void close() {
        try {
            HttpEntity entity = this.httpResponse.getEntity();
            if (entity != null && entity.getContent() != null) {
                entity.getContent().close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

