/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.httpcomponents;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;

final class HttpClient4ClientHttpResponse
implements ClientHttpResponse {
    private final HttpResponse httpResponse;
    private HttpHeaders headers;

    HttpClient4ClientHttpResponse(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public HttpStatusCode getStatusCode() throws IOException {
        return HttpStatusCode.valueOf((int)this.httpResponse.getStatusLine().getStatusCode());
    }

    public int getRawStatusCode() throws IOException {
        return this.httpResponse.getStatusLine().getStatusCode();
    }

    public String getStatusText() throws IOException {
        return this.httpResponse.getStatusLine().getReasonPhrase();
    }

    public HttpHeaders getHeaders() {
        if (this.headers == null) {
            this.headers = new HttpHeaders();
            for (Header header : this.httpResponse.getAllHeaders()) {
                this.headers.add(header.getName(), header.getValue());
            }
        }
        return this.headers;
    }

    public InputStream getBody() throws IOException {
        HttpEntity entity = this.httpResponse.getEntity();
        return entity != null ? entity.getContent() : StreamUtils.emptyInput();
    }

    public void close() {
        try {
            try {
                StreamUtils.drain((InputStream)this.getBody());
            }
            finally {
                if (this.httpResponse instanceof CloseableHttpResponse) {
                    ((CloseableHttpResponse)this.httpResponse).close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

