/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.service.httpcomponents;

import com.gooddata.sdk.service.httpcomponents.HttpClient4ClientHttpRequest;
import java.io.IOException;
import java.net.URI;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.protocol.HttpContext;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.util.Assert;

class HttpClient4HttpRequestFactory
implements ClientHttpRequestFactory {
    private final HttpClient httpClient;
    private HttpContext httpContext;

    public HttpClient4HttpRequestFactory(HttpClient httpClient) {
        Assert.notNull((Object)httpClient, (String)"HttpClient must not be null");
        this.httpClient = httpClient;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        HttpUriRequest httpRequest = this.createHttpUriRequest(httpMethod, uri);
        this.postProcessHttpRequest(httpRequest);
        HttpContext context = this.createHttpContext(httpMethod, uri);
        if (context == null) {
            context = HttpClientContext.create();
        }
        return new HttpClient4ClientHttpRequest(this.httpClient, httpRequest, context);
    }

    protected HttpUriRequest createHttpUriRequest(HttpMethod httpMethod, URI uri) {
        if (httpMethod == HttpMethod.GET) {
            return new HttpGet(uri);
        }
        if (httpMethod == HttpMethod.HEAD) {
            return new HttpHead(uri);
        }
        if (httpMethod == HttpMethod.POST) {
            return new HttpPost(uri);
        }
        if (httpMethod == HttpMethod.PUT) {
            return new HttpPut(uri);
        }
        if (httpMethod == HttpMethod.PATCH) {
            return new HttpPatch(uri);
        }
        if (httpMethod == HttpMethod.DELETE) {
            return new HttpDelete(uri);
        }
        if (httpMethod == HttpMethod.OPTIONS) {
            return new HttpOptions(uri);
        }
        if (httpMethod == HttpMethod.TRACE) {
            return new HttpTrace(uri);
        }
        throw new IllegalArgumentException("Invalid HTTP method: " + String.valueOf(httpMethod));
    }

    protected void postProcessHttpRequest(HttpUriRequest request) {
    }

    protected HttpContext createHttpContext(HttpMethod httpMethod, URI uri) {
        return this.httpContext;
    }
}

