/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpTrace;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;

public class HttpClient5ComponentsClientHttpRequestFactory
implements ClientHttpRequestFactory {
    private static final Logger logger = LoggerFactory.getLogger(HttpClient5ComponentsClientHttpRequestFactory.class);
    private final HttpClient httpClient;

    public HttpClient5ComponentsClientHttpRequestFactory(HttpClient httpClient) {
        Assert.notNull((Object)httpClient, (String)"HttpClient must not be null");
        this.httpClient = httpClient;
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        ClassicHttpRequest httpRequest = this.createHttpRequest(httpMethod, uri);
        return new HttpClient5ComponentsClientHttpRequest(this.httpClient, httpRequest);
    }

    private ClassicHttpRequest createHttpRequest(HttpMethod httpMethod, URI uri) {
        if (HttpMethod.GET.equals((Object)httpMethod)) {
            return new HttpGet(uri);
        }
        if (HttpMethod.HEAD.equals((Object)httpMethod)) {
            return new HttpHead(uri);
        }
        if (HttpMethod.POST.equals((Object)httpMethod)) {
            return new HttpPost(uri);
        }
        if (HttpMethod.PUT.equals((Object)httpMethod)) {
            return new HttpPut(uri);
        }
        if (HttpMethod.PATCH.equals((Object)httpMethod)) {
            return new HttpPatch(uri);
        }
        if (HttpMethod.DELETE.equals((Object)httpMethod)) {
            return new HttpDelete(uri);
        }
        if (HttpMethod.OPTIONS.equals((Object)httpMethod)) {
            return new HttpOptions(uri);
        }
        if (HttpMethod.TRACE.equals((Object)httpMethod)) {
            return new HttpTrace(uri);
        }
        throw new IllegalArgumentException("Invalid HTTP method: " + String.valueOf(httpMethod));
    }

    private static class HttpClient5ComponentsClientHttpRequest
    implements ClientHttpRequest {
        private final HttpClient httpClient;
        private final ClassicHttpRequest httpRequest;
        private final HttpHeaders headers;
        private final ByteArrayOutputStream bufferedOutput = new ByteArrayOutputStream(1024);

        public HttpClient5ComponentsClientHttpRequest(HttpClient httpClient, ClassicHttpRequest httpRequest) {
            this.httpClient = httpClient;
            this.httpRequest = httpRequest;
            this.headers = new HttpHeaders();
        }

        public HttpMethod getMethod() {
            return HttpMethod.valueOf((String)this.httpRequest.getMethod());
        }

        public String getMethodValue() {
            return this.httpRequest.getMethod();
        }

        public URI getURI() {
            try {
                return this.httpRequest.getUri();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get URI from request", e);
            }
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public OutputStream getBody() throws IOException {
            return this.bufferedOutput;
        }

        public ClientHttpResponse execute() throws IOException {
            ClassicHttpResponse httpResponse;
            byte[] bytes = this.bufferedOutput.toByteArray();
            if (bytes.length > 0 && this.httpRequest != null) {
                ContentType contentType = ContentType.APPLICATION_JSON;
                if (logger.isDebugEnabled()) {
                    boolean hasContentType = false;
                    for (Header header : this.httpRequest.getHeaders()) {
                        if (!"Content-Type".equalsIgnoreCase(header.getName())) continue;
                        hasContentType = true;
                        contentType = ContentType.parse((CharSequence)header.getValue());
                        break;
                    }
                    if (!hasContentType) {
                        logger.debug("No Content-Type header found, using application/json as default");
                    }
                }
                ByteArrayEntity requestEntity = new ByteArrayEntity(bytes, contentType);
                this.httpRequest.setEntity((HttpEntity)requestEntity);
            }
            this.addHeaders(this.httpRequest);
            if (this.httpClient.getClass().getName().contains("GoodDataHttpClient")) {
                try {
                    Method executeMethod = this.httpClient.getClass().getMethod("execute", ClassicHttpRequest.class);
                    httpResponse = (ClassicHttpResponse)executeMethod.invoke((Object)this.httpClient, this.httpRequest);
                }
                catch (NoSuchMethodException e) {
                    try {
                        Method executeMethod = this.httpClient.getClass().getMethod("execute", ClassicHttpRequest.class, HttpContext.class);
                        httpResponse = (ClassicHttpResponse)executeMethod.invoke((Object)this.httpClient, this.httpRequest, null);
                    }
                    catch (Exception e2) {
                        throw new IOException("Failed to execute request with GoodDataHttpClient", e2);
                    }
                }
                catch (Exception e) {
                    throw new IOException("Failed to execute request with GoodDataHttpClient", e);
                }
            } else {
                httpResponse = (ClassicHttpResponse)this.httpClient.execute(this.httpRequest, response -> response);
            }
            return new HttpClient5ComponentsClientHttpResponse(httpResponse);
        }

        private void addHeaders(ClassicHttpRequest httpRequest) {
            for (Map.Entry entry : this.headers.entrySet()) {
                String headerName = (String)entry.getKey();
                if ("Content-Length".equalsIgnoreCase(headerName)) continue;
                for (String headerValue : (List)entry.getValue()) {
                    httpRequest.setHeader(headerName, (Object)headerValue);
                }
            }
        }
    }

    private static class HttpClient5ComponentsClientHttpResponse
    implements ClientHttpResponse {
        private final ClassicHttpResponse httpResponse;
        private HttpHeaders headers;

        public HttpClient5ComponentsClientHttpResponse(ClassicHttpResponse httpResponse) {
            this.httpResponse = httpResponse;
        }

        public HttpStatusCode getStatusCode() throws IOException {
            return HttpStatusCode.valueOf((int)this.httpResponse.getCode());
        }

        public int getRawStatusCode() throws IOException {
            return this.httpResponse.getCode();
        }

        public String getStatusText() throws IOException {
            return this.httpResponse.getReasonPhrase();
        }

        public HttpHeaders getHeaders() {
            if (this.headers == null) {
                this.headers = new HttpHeaders();
                for (Header header : this.httpResponse.getHeaders()) {
                    this.headers.add(header.getName(), header.getValue());
                }
            }
            return this.headers;
        }

        public InputStream getBody() throws IOException {
            HttpEntity entity = this.httpResponse.getEntity();
            return entity != null ? entity.getContent() : InputStream.nullInputStream();
        }

        public void close() {
            try {
                if (this.httpResponse != null) {
                    this.httpResponse.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

