/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.shadowed.http4.impl.client;

import com.gooddata.shadowed.http4.HttpEntity;
import com.gooddata.shadowed.http4.HttpResponse;
import com.gooddata.shadowed.http4.StatusLine;
import com.gooddata.shadowed.http4.annotation.Contract;
import com.gooddata.shadowed.http4.annotation.ThreadingBehavior;
import com.gooddata.shadowed.http4.client.HttpResponseException;
import com.gooddata.shadowed.http4.client.ResponseHandler;
import com.gooddata.shadowed.http4.util.EntityUtils;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public abstract class AbstractResponseHandler<T>
implements ResponseHandler<T> {
    @Override
    public T handleResponse(HttpResponse response) throws HttpResponseException, IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            EntityUtils.consume(entity);
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return entity == null ? null : (T)this.handleEntity(entity);
    }

    public abstract T handleEntity(HttpEntity var1) throws IOException;
}

