/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.sdk.common;

import com.gooddata.http.client.GoodDataHttpClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpTrace;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;

public class HttpClient5ComponentsClientHttpRequestFactory
implements ClientHttpRequestFactory {
    private static final Logger logger = LoggerFactory.getLogger(HttpClient5ComponentsClientHttpRequestFactory.class);
    private final HttpClient httpClient;

    public HttpClient5ComponentsClientHttpRequestFactory(HttpClient httpClient) {
        Assert.notNull((Object)httpClient, (String)"HttpClient must not be null");
        this.httpClient = httpClient;
    }

    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) throws IOException {
        ClassicHttpRequest httpRequest = this.createHttpRequest(httpMethod, uri);
        return new HttpClient5ComponentsClientHttpRequest(this.httpClient, httpRequest);
    }

    private ClassicHttpRequest createHttpRequest(HttpMethod httpMethod, URI uri) {
        if (HttpMethod.GET.equals((Object)httpMethod)) {
            return new HttpGet(uri);
        }
        if (HttpMethod.HEAD.equals((Object)httpMethod)) {
            return new HttpHead(uri);
        }
        if (HttpMethod.POST.equals((Object)httpMethod)) {
            return new HttpPost(uri);
        }
        if (HttpMethod.PUT.equals((Object)httpMethod)) {
            return new HttpPut(uri);
        }
        if (HttpMethod.PATCH.equals((Object)httpMethod)) {
            return new HttpPatch(uri);
        }
        if (HttpMethod.DELETE.equals((Object)httpMethod)) {
            return new HttpDelete(uri);
        }
        if (HttpMethod.OPTIONS.equals((Object)httpMethod)) {
            return new HttpOptions(uri);
        }
        if (HttpMethod.TRACE.equals((Object)httpMethod)) {
            return new HttpTrace(uri);
        }
        throw new IllegalArgumentException("Invalid HTTP method: " + String.valueOf(httpMethod));
    }

    private static class HttpClient5ComponentsClientHttpRequest
    implements ClientHttpRequest {
        private final HttpClient httpClient;
        private final ClassicHttpRequest httpRequest;
        private final HttpHeaders headers;
        private final ByteArrayOutputStream bufferedOutput = new ByteArrayOutputStream(1024);

        HttpClient5ComponentsClientHttpRequest(HttpClient httpClient, ClassicHttpRequest httpRequest) {
            this.httpClient = httpClient;
            this.httpRequest = httpRequest;
            this.headers = new HttpHeaders();
        }

        public HttpMethod getMethod() {
            return HttpMethod.valueOf((String)this.httpRequest.getMethod());
        }

        public String getMethodValue() {
            return this.httpRequest.getMethod();
        }

        public URI getURI() {
            try {
                return this.httpRequest.getUri();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get URI from request", e);
            }
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public OutputStream getBody() {
            return this.bufferedOutput;
        }

        public ClientHttpResponse execute() throws IOException {
            byte[] bytes = this.bufferedOutput.toByteArray();
            if (bytes.length > 0 && this.httpRequest instanceof HttpEntityContainer) {
                ContentType contentType = ContentType.APPLICATION_JSON;
                String contentTypeHeader = this.headers.getFirst("Content-Type");
                if (contentTypeHeader != null) {
                    try {
                        contentType = ContentType.parse((CharSequence)contentTypeHeader);
                    }
                    catch (Exception e) {
                        logger.warn("Failed to parse Content-Type header '{}', using default", (Object)contentTypeHeader, (Object)e);
                    }
                }
                ByteArrayEntity requestEntity = new ByteArrayEntity(bytes, contentType);
                this.httpRequest.setEntity((HttpEntity)requestEntity);
            }
            this.addHeaders(this.httpRequest);
            ClassicHttpResponse httpResponse = this.executeClassic(this.httpClient, this.httpRequest);
            return new HttpClient5ComponentsClientHttpResponse(httpResponse);
        }

        private ClassicHttpResponse executeClassic(HttpClient httpClient, ClassicHttpRequest httpRequest) throws IOException {
            if (logger.isDebugEnabled()) {
                try {
                    logger.debug("Executing request: {} {}", (Object)httpRequest.getMethod(), (Object)httpRequest.getUri());
                }
                catch (Exception e) {
                    logger.debug("Executing request: {}", (Object)httpRequest.getMethod());
                }
            }
            if (httpClient instanceof GoodDataHttpClient) {
                logger.debug("Using GoodDataHttpClient execute");
                return ((GoodDataHttpClient)httpClient).execute(httpRequest);
            }
            if (httpClient instanceof CloseableHttpClient) {
                logger.debug("Using CloseableHttpClient executeOpen");
                return ((CloseableHttpClient)httpClient).executeOpen(null, httpRequest, null);
            }
            logger.debug("Using standard HttpClient executeOpen");
            return httpClient.executeOpen(null, httpRequest, null);
        }

        private void addHeaders(ClassicHttpRequest httpRequest) {
            for (Map.Entry entry : this.headers.entrySet()) {
                String headerName = (String)entry.getKey();
                if ("Content-Length".equalsIgnoreCase(headerName) || "Transfer-Encoding".equalsIgnoreCase(headerName) || "Connection".equalsIgnoreCase(headerName) || "Host".equalsIgnoreCase(headerName)) continue;
                httpRequest.removeHeaders(headerName);
                for (String headerValue : (List)entry.getValue()) {
                    if (headerValue == null) continue;
                    httpRequest.addHeader(headerName, (Object)headerValue);
                }
            }
        }
    }

    private static class HttpClient5ComponentsClientHttpResponse
    implements ClientHttpResponse {
        private final ClassicHttpResponse httpResponse;
        private HttpHeaders headers;

        public HttpClient5ComponentsClientHttpResponse(ClassicHttpResponse httpResponse) {
            this.httpResponse = httpResponse;
        }

        public HttpStatusCode getStatusCode() throws IOException {
            return HttpStatusCode.valueOf((int)this.httpResponse.getCode());
        }

        public int getRawStatusCode() throws IOException {
            return this.httpResponse.getCode();
        }

        public String getStatusText() throws IOException {
            return this.httpResponse.getReasonPhrase();
        }

        public HttpHeaders getHeaders() {
            if (this.headers == null) {
                this.headers = new HttpHeaders();
                for (Header header : this.httpResponse.getHeaders()) {
                    this.headers.add(header.getName(), header.getValue());
                }
            }
            return this.headers;
        }

        public InputStream getBody() throws IOException {
            HttpEntity entity = this.httpResponse.getEntity();
            if (entity == null) {
                logger.debug("No entity in response, returning empty stream");
                return InputStream.nullInputStream();
            }
            try {
                InputStream content = entity.getContent();
                if (content == null) {
                    logger.debug("Entity content is null, returning empty stream");
                    return InputStream.nullInputStream();
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Returning entity content stream - repeatable: {}, streaming: {}, content length: {}", new Object[]{entity.isRepeatable(), entity.isStreaming(), entity.getContentLength()});
                }
                return content;
            }
            catch (IllegalStateException e) {
                logger.warn("Entity content stream is in illegal state (likely already consumed): {}", (Object)e.getMessage());
                throw new IOException("Response stream is no longer available: " + e.getMessage(), e);
            }
        }

        public void close() {
            try {
                logger.debug("Closing HTTP response");
                if (this.httpResponse != null) {
                    this.httpResponse.close();
                }
            }
            catch (IOException e) {
                logger.debug("Unable to close HTTP response", (Throwable)e);
            }
        }
    }
}

