/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.shadowed.http4.impl.conn;

import com.gooddata.shadowed.http4.HttpHost;
import com.gooddata.shadowed.http4.annotation.Contract;
import com.gooddata.shadowed.http4.annotation.ThreadingBehavior;
import com.gooddata.shadowed.http4.conn.SchemePortResolver;
import com.gooddata.shadowed.http4.conn.UnsupportedSchemeException;
import com.gooddata.shadowed.http4.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultSchemePortResolver
implements SchemePortResolver {
    public static final DefaultSchemePortResolver INSTANCE = new DefaultSchemePortResolver();

    @Override
    public int resolve(HttpHost host) throws UnsupportedSchemeException {
        Args.notNull(host, "HTTP host");
        int port = host.getPort();
        if (port > 0) {
            return port;
        }
        String name = host.getSchemeName();
        if (name.equalsIgnoreCase("http")) {
            return 80;
        }
        if (name.equalsIgnoreCase("https")) {
            return 443;
        }
        throw new UnsupportedSchemeException(name + " protocol is not supported");
    }
}

