/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.shadowed.http4.impl.cookie;

import com.gooddata.shadowed.http4.annotation.Contract;
import com.gooddata.shadowed.http4.annotation.ThreadingBehavior;
import com.gooddata.shadowed.http4.cookie.ClientCookie;
import com.gooddata.shadowed.http4.cookie.CommonCookieAttributeHandler;
import com.gooddata.shadowed.http4.cookie.Cookie;
import com.gooddata.shadowed.http4.cookie.CookieOrigin;
import com.gooddata.shadowed.http4.cookie.CookieRestrictionViolationException;
import com.gooddata.shadowed.http4.cookie.MalformedCookieException;
import com.gooddata.shadowed.http4.cookie.SetCookie;
import com.gooddata.shadowed.http4.cookie.SetCookie2;
import com.gooddata.shadowed.http4.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2965VersionAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        int version = -1;
        try {
            version = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            version = -1;
        }
        if (version < 0) {
            throw new MalformedCookieException("Invalid cookie version.");
        }
        cookie.setVersion(version);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie instanceof SetCookie2 && cookie instanceof ClientCookie && !((ClientCookie)cookie).containsAttribute("version")) {
            throw new CookieRestrictionViolationException("Violates RFC 2965. Version attribute is required.");
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        return true;
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

