/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.shadowed.http4.protocol;

import com.gooddata.shadowed.http4.HttpException;
import com.gooddata.shadowed.http4.HttpResponse;
import com.gooddata.shadowed.http4.HttpResponseInterceptor;
import com.gooddata.shadowed.http4.annotation.Contract;
import com.gooddata.shadowed.http4.annotation.ThreadingBehavior;
import com.gooddata.shadowed.http4.protocol.HttpContext;
import com.gooddata.shadowed.http4.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseServer
implements HttpResponseInterceptor {
    private final String originServer;

    public ResponseServer(String originServer) {
        this.originServer = originServer;
    }

    public ResponseServer() {
        this(null);
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        if (!response.containsHeader("Server") && this.originServer != null) {
            response.addHeader("Server", this.originServer);
        }
    }
}

