/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.Touch;
import com.googlecode.androidannotations.helper.IdAnnotationHelper;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.EBeansHolder;
import com.googlecode.androidannotations.rclass.IRClass;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class TouchProcessor
implements DecoratingElementProcessor {
    private IdAnnotationHelper helper;

    public TouchProcessor(ProcessingEnvironment processingEnv, IRClass rClass) {
        this.helper = new IdAnnotationHelper(processingEnv, this.getTarget(), rClass);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return Touch.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) {
        EBeansHolder.Classes classes = holder.classes();
        String methodName = element.getSimpleName().toString();
        ExecutableElement executableElement = (ExecutableElement)element;
        List<? extends VariableElement> parameters = executableElement.getParameters();
        TypeMirror returnType = executableElement.getReturnType();
        boolean returnMethodResult = returnType.getKind() != TypeKind.VOID;
        boolean hasItemParameter = parameters.size() == 2;
        List<JFieldRef> idsRefs = this.helper.extractAnnotationFieldRefs(holder, element, IRClass.Res.ID, true);
        JDefinedClass listenerClass = codeModel.anonymousClass(classes.ON_TOUCH_LISTENER);
        JMethod listenerMethod = listenerClass.method(1, codeModel.BOOLEAN, "onTouch");
        listenerMethod.annotate(Override.class);
        JVar viewParam = listenerMethod.param(classes.VIEW, "view");
        JVar eventParam = listenerMethod.param(classes.MOTION_EVENT, "event");
        JBlock listenerMethodBody = listenerMethod.body();
        JInvocation call = JExpr.invoke(methodName);
        if (returnMethodResult) {
            listenerMethodBody._return(call);
        } else {
            listenerMethodBody.add(call);
            listenerMethodBody._return(JExpr.TRUE);
        }
        call.arg(eventParam);
        if (hasItemParameter) {
            call.arg(viewParam);
        }
        for (JFieldRef idRef : idsRefs) {
            JBlock block = holder.afterSetContentView.body().block();
            JInvocation findViewById = JExpr.invoke("findViewById");
            JVar view = block.decl(classes.VIEW, "view", findViewById.arg(idRef));
            block._if(view.ne(JExpr._null()))._then().invoke((JExpression)view, "setOnTouchListener").arg(JExpr._new(listenerClass));
        }
    }
}

