/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.validation;

import com.googlecode.androidannotations.annotations.AfterTextChange;
import com.googlecode.androidannotations.helper.IdAnnotationHelper;
import com.googlecode.androidannotations.helper.IdValidatorHelper;
import com.googlecode.androidannotations.model.AnnotationElements;
import com.googlecode.androidannotations.rclass.IRClass;
import com.googlecode.androidannotations.validation.ElementValidator;
import com.googlecode.androidannotations.validation.IsValid;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;

public class AfterTextChangeValidator
implements ElementValidator {
    private final IdValidatorHelper validatorHelper;
    private final IdAnnotationHelper annotationHelper;

    public AfterTextChangeValidator(ProcessingEnvironment processingEnv, IRClass rClass) {
        this.annotationHelper = new IdAnnotationHelper(processingEnv, this.getTarget(), rClass);
        this.validatorHelper = new IdValidatorHelper(this.annotationHelper);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return AfterTextChange.class;
    }

    @Override
    public boolean validate(Element element, AnnotationElements validatedElements) {
        IsValid valid = new IsValid();
        this.validatorHelper.enclosingElementHasEnhancedViewSupportAnnotation(element, validatedElements, valid);
        this.validatorHelper.resIdsExist(element, IRClass.Res.ID, IdValidatorHelper.FallbackStrategy.USE_ELEMENT_NAME, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.doesntThrowException(element, valid);
        ExecutableElement executableElement = (ExecutableElement)element;
        this.validatorHelper.returnTypeIsVoid(executableElement, valid);
        this.haveAfterTextChangedMethodParameters(executableElement, valid);
        return valid.isValid();
    }

    private void haveAfterTextChangedMethodParameters(ExecutableElement executableElement, IsValid valid) {
        List<? extends VariableElement> parameters = executableElement.getParameters();
        boolean editableParameterFound = false;
        boolean textViewParameterFound = false;
        for (VariableElement variableElement : parameters) {
            String parameterType = ((Object)variableElement.asType()).toString();
            if (parameterType.equals("android.text.Editable")) {
                if (editableParameterFound) {
                    this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter declaration. you can declare only one parameter of type android.text.Editable");
                    valid.invalidate();
                }
                editableParameterFound = true;
                continue;
            }
            if (parameterType.equals("android.widget.TextView")) {
                if (textViewParameterFound) {
                    this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter declaration. you can declare only one parameter of type android.widget.TextView");
                    valid.invalidate();
                }
                textViewParameterFound = true;
                continue;
            }
            valid.invalidate();
            this.annotationHelper.printAnnotationError(executableElement, "Unrecognized parameter type. %s can only have a android.widget.TextView parameter and/or an android.text.Editable parameter. See android.text.TextWatcher.afterTextChanged() for more informations.");
        }
    }
}

