/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.validation;

import com.googlecode.androidannotations.annotations.EActivity;
import com.googlecode.androidannotations.helper.AndroidManifest;
import com.googlecode.androidannotations.helper.IdAnnotationHelper;
import com.googlecode.androidannotations.helper.IdValidatorHelper;
import com.googlecode.androidannotations.model.AnnotationElements;
import com.googlecode.androidannotations.rclass.IRClass;
import com.googlecode.androidannotations.validation.ElementValidator;
import com.googlecode.androidannotations.validation.IsValid;
import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;

public class EActivityValidator
implements ElementValidator {
    private final IdValidatorHelper validatorHelper;
    private final AndroidManifest androidManifest;

    public EActivityValidator(ProcessingEnvironment processingEnv, IRClass rClass, AndroidManifest androidManifest) {
        this.androidManifest = androidManifest;
        IdAnnotationHelper annotationHelper = new IdAnnotationHelper(processingEnv, this.getTarget(), rClass);
        this.validatorHelper = new IdValidatorHelper(annotationHelper);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return EActivity.class;
    }

    @Override
    public boolean validate(Element element, AnnotationElements validatedElements) {
        IsValid valid = new IsValid();
        this.validatorHelper.extendsActivity(element, valid);
        this.validatorHelper.resIdsExist(element, IRClass.Res.LAYOUT, IdValidatorHelper.FallbackStrategy.ALLOW_NO_RES_ID, valid);
        this.validatorHelper.isNotFinal(element, valid);
        this.validatorHelper.componentRegistered(element, this.androidManifest, valid);
        return valid.isValid();
    }
}

