/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing;

import com.googlecode.androidannotations.annotations.InstanceState;
import com.googlecode.androidannotations.helper.APTCodeModelHelper;
import com.googlecode.androidannotations.helper.AnnotationHelper;
import com.googlecode.androidannotations.helper.BundleHelper;
import com.googlecode.androidannotations.helper.CanonicalNameConstants;
import com.googlecode.androidannotations.processing.DecoratingElementProcessor;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCast;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;

public class InstanceStateProcessor
implements DecoratingElementProcessor {
    private static final String BUNDLE_PARAM_NAME = "bundle";
    public static final Map<String, String> methodSuffixNameByTypeName = new HashMap<String, String>();
    private final APTCodeModelHelper helper = new APTCodeModelHelper();
    private AnnotationHelper annotationHelper;

    public InstanceStateProcessor(ProcessingEnvironment processingEnv) {
        this.annotationHelper = new AnnotationHelper(processingEnv);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return InstanceState.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) {
        String fieldName = element.getSimpleName().toString();
        JBlock saveStateBody = this.getSaveStateMethodBody(codeModel, holder);
        JBlock restoreStateBody = this.getRestoreStateBody(codeModel, holder);
        BundleHelper bundleHelper = new BundleHelper(this.annotationHelper, element);
        JFieldRef ref = JExpr.ref(fieldName);
        saveStateBody.invoke((JExpression)JExpr.ref(BUNDLE_PARAM_NAME), bundleHelper.getMethodNameToSave()).arg(fieldName).arg(ref);
        JInvocation restoreMethodCall = JExpr.invoke((JExpression)JExpr.ref("savedInstanceState"), bundleHelper.getMethodNameToRestore()).arg(fieldName);
        if (bundleHelper.restoreCallNeedCastStatement()) {
            JClass jclass = this.helper.typeMirrorToJClass(element.asType(), holder);
            JCast castStatement = JExpr.cast(jclass, restoreMethodCall);
            restoreStateBody.assign(ref, castStatement);
            if (bundleHelper.restoreCallNeedsSuppressWarning() && holder.restoreSavedInstanceStateMethod.annotations().size() == 0) {
                holder.restoreSavedInstanceStateMethod.annotate(SuppressWarnings.class).param("value", "unchecked");
            }
        } else {
            restoreStateBody.assign(ref, restoreMethodCall);
        }
    }

    private JBlock getRestoreStateBody(JCodeModel codeModel, EBeanHolder holder) {
        if (holder.restoreSavedInstanceStateMethod == null) {
            holder.restoreSavedInstanceStateMethod = holder.generatedClass.method(4, codeModel.VOID, "restoreSavedInstanceState_");
            JVar savedInstanceState = holder.restoreSavedInstanceStateMethod.param(holder.classes().BUNDLE, "savedInstanceState");
            holder.initIfActivityBody.invoke(holder.restoreSavedInstanceStateMethod).arg(savedInstanceState);
            holder.restoreSavedInstanceStateMethod.body()._if(JExpr.ref("savedInstanceState").eq(JExpr._null()))._then()._return();
        }
        return holder.restoreSavedInstanceStateMethod.body();
    }

    private JBlock getSaveStateMethodBody(JCodeModel codeModel, EBeanHolder holder) {
        if (holder.saveInstanceStateBlock == null) {
            JMethod method = holder.generatedClass.method(1, codeModel.VOID, "onSaveInstanceState");
            method.annotate(Override.class);
            method.param(holder.classes().BUNDLE, BUNDLE_PARAM_NAME);
            holder.saveInstanceStateBlock = method.body();
            holder.saveInstanceStateBlock.invoke(JExpr._super(), "onSaveInstanceState").arg(JExpr.ref(BUNDLE_PARAM_NAME));
        }
        return holder.saveInstanceStateBlock;
    }

    static {
        methodSuffixNameByTypeName.put("android.os.Bundle", "Bundle");
        methodSuffixNameByTypeName.put("boolean", "Boolean");
        methodSuffixNameByTypeName.put("boolean[]", "BooleanArray");
        methodSuffixNameByTypeName.put("byte", "Byte");
        methodSuffixNameByTypeName.put("byte[]", "ByteArray");
        methodSuffixNameByTypeName.put("char", "Char");
        methodSuffixNameByTypeName.put("char[]", "CharArray");
        methodSuffixNameByTypeName.put(CanonicalNameConstants.CHAR_SEQUENCE, "CharSequence");
        methodSuffixNameByTypeName.put("double", "Double");
        methodSuffixNameByTypeName.put("double[]", "DoubleArray");
        methodSuffixNameByTypeName.put("float", "Float");
        methodSuffixNameByTypeName.put("float[]", "FloatArray");
        methodSuffixNameByTypeName.put("int", "Int");
        methodSuffixNameByTypeName.put("int[]", "IntArray");
        methodSuffixNameByTypeName.put("java.util.ArrayList<java.lang.Integer>", "IntegerArrayList");
        methodSuffixNameByTypeName.put("long", "Long");
        methodSuffixNameByTypeName.put("long[]", "LongArray");
        methodSuffixNameByTypeName.put("short", "Short");
        methodSuffixNameByTypeName.put("short[]", "ShortArray");
        methodSuffixNameByTypeName.put(CanonicalNameConstants.STRING, "String");
        methodSuffixNameByTypeName.put("java.lang.String[]", "StringArray");
        methodSuffixNameByTypeName.put("java.util.ArrayList<java.lang.String>", "StringArrayList");
    }
}

