/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.processing.rest;

import com.googlecode.androidannotations.annotations.rest.Head;
import com.googlecode.androidannotations.processing.EBeanHolder;
import com.googlecode.androidannotations.processing.rest.MethodProcessor;
import com.googlecode.androidannotations.processing.rest.MethodProcessorHolder;
import com.googlecode.androidannotations.processing.rest.RestImplementationsHolder;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JVar;
import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

public class HeadProcessor
extends MethodProcessor {
    private EBeanHolder holder;

    public HeadProcessor(ProcessingEnvironment processingEnv, RestImplementationsHolder restImplementationHolder) {
        super(processingEnv, restImplementationHolder);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return Head.class;
    }

    @Override
    public void process(Element element, JCodeModel codeModel, EBeanHolder holder) throws Exception {
        this.holder = holder;
        ExecutableElement executableElement = (ExecutableElement)element;
        TypeMirror returnType = executableElement.getReturnType();
        JClass expectedClass = holder.refClass(((Object)returnType).toString());
        Head headAnnotation = element.getAnnotation(Head.class);
        String urlSuffix = headAnnotation.value();
        this.generateRestTemplateCallBlock(new MethodProcessorHolder(holder, executableElement, urlSuffix, expectedClass, expectedClass, codeModel));
    }

    @Override
    protected JInvocation addResultCallMethod(JInvocation restCall, MethodProcessorHolder methodHolder) {
        return JExpr.invoke((JExpression)restCall, "getHeaders");
    }

    @Override
    protected JInvocation addHttpEntityVar(JInvocation restCall, MethodProcessorHolder methodHolder) {
        return restCall.arg(JExpr._null());
    }

    @Override
    protected JInvocation addResponseEntityArg(JInvocation restCall, MethodProcessorHolder methodHolder) {
        return restCall.arg(JExpr._null());
    }

    @Override
    protected JVar addHttpHeadersVar(JBlock body, ExecutableElement executableElement) {
        return this.generateHttpHeadersVar(this.holder, body, executableElement);
    }
}

