/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.androidannotations.validation.rest;

import com.googlecode.androidannotations.annotations.rest.Accept;
import com.googlecode.androidannotations.helper.TargetAnnotationHelper;
import com.googlecode.androidannotations.helper.ValidatorHelper;
import com.googlecode.androidannotations.model.AnnotationElements;
import com.googlecode.androidannotations.validation.ElementValidator;
import com.googlecode.androidannotations.validation.IsValid;
import java.lang.annotation.Annotation;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public class AcceptValidator
implements ElementValidator {
    private ValidatorHelper validatorHelper;

    public AcceptValidator(ProcessingEnvironment processingEnv) {
        TargetAnnotationHelper annotationHelper = new TargetAnnotationHelper(processingEnv, this.getTarget());
        this.validatorHelper = new ValidatorHelper(annotationHelper);
    }

    @Override
    public Class<? extends Annotation> getTarget() {
        return Accept.class;
    }

    @Override
    public boolean validate(Element element, AnnotationElements validatedElements) {
        IsValid valid = new IsValid();
        if (element instanceof TypeElement) {
            this.validatorHelper.elementHasRestAnnotation(element, validatedElements, valid);
        } else {
            ExecutableElement executableElement = (ExecutableElement)element;
            this.validatorHelper.enclosingElementHasRestAnnotation(executableElement, validatedElements, valid);
            this.validatorHelper.elementHasGetOrPostAnnotation(executableElement, validatedElements, valid);
            this.validatorHelper.throwsOnlyRestClientException(executableElement, valid);
        }
        return valid.isValid();
    }
}

