/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.googleplus;

import com.googlecode.googleplus.GooglePlusConfiguration;
import com.googlecode.googleplus.Plus;
import com.googlecode.googleplus.core.OAuth2RefreshCallback;
import com.googlecode.googleplus.core.OAuth2RefreshListener;
import com.googlecode.googleplus.impl.PlusImpl;
import org.springframework.social.oauth2.AbstractOAuth2ServiceProvider;
import org.springframework.social.oauth2.AccessGrant;
import org.springframework.social.oauth2.OAuth2Operations;
import org.springframework.social.oauth2.OAuth2Template;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GooglePlusFactory
extends AbstractOAuth2ServiceProvider<Plus> {
    private GooglePlusConfiguration config;

    public GooglePlusFactory(String clientId, String clientSecret, GooglePlusConfiguration config) {
        super((OAuth2Operations)new OAuth2Template(clientId, clientSecret, "https://accounts.google.com/o/oauth2/auth", "https://accounts.google.com/o/oauth2/token"));
        this.config = config;
    }

    public GooglePlusFactory(String clientId, String clientSecret) {
        this(clientId, clientSecret, new GooglePlusConfiguration());
    }

    @Deprecated
    public Plus getApi(String accessToken) {
        return this.getApi(accessToken, null, null);
    }

    public Plus getApi(String accessToken, String refreshToken, OAuth2RefreshListener listener) {
        this.configureProxy();
        PlusImpl plus = new PlusImpl(accessToken, this.config, new DefaultOAuth2RefreshCallback(accessToken, refreshToken, listener));
        plus.init();
        return plus;
    }

    private void configureProxy() {
        if (this.config.getProxyHost() != null) {
            System.setProperty("http.proxyHost", this.config.getProxyHost());
        }
        if (this.config.getProxyPort() != 0) {
            System.setProperty("http.proxyPort", String.valueOf(this.config.getProxyPort()));
        }
    }

    public final class DefaultOAuth2RefreshCallback
    implements OAuth2RefreshCallback {
        private String accessToken;
        private String refreshToken;
        private OAuth2RefreshListener listener;

        public DefaultOAuth2RefreshCallback(String accessToken, String refreshToken, OAuth2RefreshListener listener) {
            this.accessToken = accessToken;
            this.refreshToken = refreshToken;
            this.listener = listener;
        }

        public String refreshToken() {
            if (this.refreshToken == null) {
                return null;
            }
            AccessGrant grant = GooglePlusFactory.this.getOAuthOperations().refreshAccess(this.refreshToken, null, null);
            if (this.listener != null) {
                this.listener.tokensRefreshed(this.accessToken, grant);
            }
            return grant.getAccessToken();
        }
    }
}

