/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.awt.EventQueue;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;
import playn.core.AbstractAssets;
import playn.core.Image;
import playn.core.PlayN;
import playn.core.ResourceCallback;
import playn.core.Sound;
import playn.java.JavaAudio;
import playn.java.JavaErrorImage;
import playn.java.JavaImage;
import playn.java.JavaStaticImage;

public class JavaAssets
extends AbstractAssets {
    private static final boolean asyncLoad = Boolean.getBoolean("playn.java.asyncLoad");
    private String pathPrefix = "";

    static void doResourceAction(Runnable action) {
        if (asyncLoad) {
            EventQueue.invokeLater(action);
        } else {
            action.run();
        }
    }

    public void setPathPrefix(String prefix) {
        if (prefix.startsWith("/") || prefix.endsWith("/")) {
            throw new IllegalArgumentException("Prefix must not start or end with '/'.");
        }
        this.pathPrefix = prefix.length() == 0 ? prefix : prefix + "/";
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    InputStream getAssetStream(String path) throws IOException {
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.pathPrefix + path);
        if (in == null) {
            throw new FileNotFoundException(path);
        }
        return in;
    }

    protected Image doGetImage(String path) {
        try {
            return this.createImage(ImageIO.read(this.requireResource(this.pathPrefix + path)));
        }
        catch (Exception e) {
            PlayN.log().warn("Could not load image at " + this.pathPrefix + path, (Throwable)e);
            return new JavaErrorImage(e);
        }
    }

    protected Sound doGetSound(String path) {
        path = path + ".mp3";
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.pathPrefix + path);
        if (in == null) {
            PlayN.log().warn("Could not find sound " + this.pathPrefix + path);
            return ((JavaAudio)PlayN.audio()).createNoopSound();
        }
        return ((JavaAudio)PlayN.audio()).createSound(path, in);
    }

    protected void doGetText(final String path, final ResourceCallback<String> callback) {
        JavaAssets.doResourceAction(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.done((Object)Resources.toString((URL)JavaAssets.this.requireResource(JavaAssets.this.pathPrefix + path), (Charset)Charsets.UTF_8));
                }
                catch (Exception e) {
                    callback.error((Throwable)e);
                }
            }
        });
    }

    protected JavaImage createImage(BufferedImage source) {
        return new JavaStaticImage(source);
    }

    protected URL requireResource(String path) throws FileNotFoundException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(path);
        if (url == null) {
            throw new FileNotFoundException(path);
        }
        return url;
    }
}

