/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import playn.core.Asserts;
import playn.core.Image;
import playn.core.Pattern;
import playn.java.JavaImageRegion;
import playn.java.JavaPattern;

abstract class JavaImage
implements Image {
    protected BufferedImage img;

    JavaImage(BufferedImage img) {
        this.img = img;
    }

    public int width() {
        return this.img.getWidth();
    }

    public int height() {
        return this.img.getHeight();
    }

    public boolean isReady() {
        return this.img != null;
    }

    public Image.Region subImage(float sx, float sy, float swidth, float sheight) {
        Asserts.checkArgument((sx >= 0.0f && sy >= 0.0f && swidth > 0.0f && sheight > 0.0f && sx + swidth <= (float)this.width() && sy + sheight <= (float)this.height() ? 1 : 0) != 0, (Object)("Invalid bounds for subimage [image=" + this.width() + "x" + this.height() + ", subImage=" + swidth + "x" + sheight + "+" + sx + "+" + sy + "]"));
        return new JavaImageRegion(this, sx, sy, swidth, sheight);
    }

    public Pattern toPattern() {
        return new JavaPattern(this);
    }

    TexturePaint createTexture(float width, float height) {
        return new TexturePaint(this.img, new Rectangle2D.Float(0.0f, 0.0f, width, height));
    }

    void draw(Graphics2D gfx, float x, float y, float w, float h) {
        AffineTransform tx = new AffineTransform(w / (float)this.width(), 0.0f, 0.0f, h / (float)this.height(), x, y);
        gfx.drawImage(this.img, tx, null);
    }

    void draw(Graphics2D gfx, float dx, float dy, float dw, float dh, float sx, float sy, float sw, float sh) {
        gfx.drawImage(this.img, (int)dx, (int)dy, (int)(dx + dw), (int)(dy + dh), (int)sx, (int)sy, (int)(sx + sw), (int)(sy + sh), null);
    }
}

