/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import playn.core.Net;
import playn.core.util.Callback;

public class JavaNet
implements Net {
    private static final int BUF_SIZE = 4096;

    public void get(String urlStr, Callback<String> callback) {
        try {
            URL url = new URL(this.canonicalizeUrl(urlStr));
            InputStream stream = url.openStream();
            InputStreamReader reader = new InputStreamReader(stream);
            callback.onSuccess((Object)this.readFully(reader));
        }
        catch (MalformedURLException e) {
            callback.onFailure((Throwable)e);
        }
        catch (IOException e) {
            callback.onFailure((Throwable)e);
        }
    }

    public void post(String urlStr, String data, Callback<String> callback) {
        try {
            URL url = new URL(this.canonicalizeUrl(urlStr));
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setAllowUserInteraction(false);
            conn.setRequestProperty("Content-type", "text/xml; charset=UTF-8");
            conn.connect();
            conn.getOutputStream().write(data.getBytes("UTF-8"));
            conn.getOutputStream().close();
            callback.onSuccess((Object)this.readFully(new InputStreamReader(conn.getInputStream())));
            conn.disconnect();
        }
        catch (MalformedURLException e) {
            callback.onFailure((Throwable)e);
        }
        catch (IOException e) {
            callback.onFailure((Throwable)e);
        }
    }

    private String canonicalizeUrl(String url) {
        if (!url.startsWith("http")) {
            return "http://" + this.server() + url;
        }
        return url;
    }

    private String server() {
        return "127.0.0.1:8080";
    }

    private String readFully(Reader reader) throws IOException {
        StringBuffer result = new StringBuffer();
        char[] buf = new char[4096];
        int len = 0;
        while (-1 != (len = reader.read(buf))) {
            result.append(buf, 0, len);
        }
        return result.toString();
    }
}

