/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.awt.EventQueue;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import javax.imageio.ImageIO;
import playn.core.AbstractAssets;
import playn.core.Image;
import playn.core.PlayN;
import playn.core.ResourceCallback;
import playn.core.Sound;
import playn.core.gl.Scale;
import playn.java.JavaAudio;
import playn.java.JavaGraphics;

public class JavaAssets
extends AbstractAssets {
    private static final boolean asyncLoad = Boolean.getBoolean("playn.java.asyncLoad");
    private final JavaGraphics graphics;
    private final JavaAudio audio;
    private String pathPrefix = "";

    static void doResourceAction(Runnable action) {
        if (asyncLoad) {
            EventQueue.invokeLater(action);
        } else {
            action.run();
        }
    }

    public JavaAssets(JavaGraphics graphics, JavaAudio audio) {
        this.graphics = graphics;
        this.audio = audio;
    }

    public void setPathPrefix(String prefix) {
        if (prefix.startsWith("/") || prefix.endsWith("/")) {
            throw new IllegalArgumentException("Prefix must not start or end with '/'.");
        }
        this.pathPrefix = prefix.length() == 0 ? prefix : prefix + "/";
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    InputStream getAssetStream(String path) throws IOException {
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.pathPrefix + path);
        if (in == null) {
            throw new FileNotFoundException(path);
        }
        return in;
    }

    protected Image doGetImage(String path) {
        Exception error = null;
        for (Scale.ScaledResource rsrc : this.graphics.ctx().scale.getScaledResources(this.pathPrefix + path)) {
            try {
                return this.graphics.createStaticImage(ImageIO.read(this.requireResource(rsrc.path)), rsrc.scale);
            }
            catch (FileNotFoundException fnfe) {
                error = fnfe;
            }
            catch (Exception e) {
                error = e;
                break;
            }
        }
        PlayN.log().warn("Could not load image: " + this.pathPrefix + path, (Throwable)error);
        return this.graphics.createErrorImage(error != null ? error : new FileNotFoundException(path));
    }

    protected Sound doGetSound(String path) {
        path = path + ".mp3";
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(this.pathPrefix + path);
        if (in == null) {
            PlayN.log().warn("Could not find sound " + this.pathPrefix + path);
            return this.audio.createNoopSound();
        }
        return this.audio.createSound(path, in);
    }

    protected void doGetText(final String path, final ResourceCallback<String> callback) {
        JavaAssets.doResourceAction(new Runnable(){

            @Override
            public void run() {
                try {
                    callback.done((Object)Resources.toString((URL)JavaAssets.this.requireResource(JavaAssets.this.pathPrefix + path), (Charset)Charsets.UTF_8));
                }
                catch (Exception e) {
                    callback.error((Throwable)e);
                }
            }
        });
    }

    protected URL requireResource(String path) throws FileNotFoundException {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(path);
        if (url == null) {
            throw new FileNotFoundException(path);
        }
        return url;
    }
}

