/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import playn.core.Asserts;
import playn.core.InternalTransform;
import playn.core.Platform;
import playn.core.PlayN;
import playn.core.StockInternalTransform;
import playn.core.gl.GLContext;
import playn.core.gl.GLShader;
import playn.core.gl.GroupLayerGL;
import playn.java.JavaGLShader;
import playn.java.JavaPlatform;

class JavaGLContext
extends GLContext {
    public static final boolean CHECK_ERRORS = Boolean.getBoolean("playn.glerrors");
    private StockInternalTransform rootXform;
    private GLShader.Texture texShader;
    private GLShader.Color colorShader;

    JavaGLContext(JavaPlatform platform, float scaleFactor, int screenWidth, int screenHeight) {
        super((Platform)platform, scaleFactor);
        this.setSize(screenWidth, screenHeight);
        this.rootXform = new StockInternalTransform();
        this.rootXform.uniformScale(scaleFactor);
    }

    public void deleteFramebuffer(Object fbuf) {
        EXTFramebufferObject.glDeleteFramebuffersEXT((int)((Integer)fbuf));
    }

    public Object createTexture(boolean repeatX, boolean repeatY) {
        int texture = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)texture);
        GL11.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GL11.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GL11.glTexParameterf((int)3553, (int)10242, (float)(repeatX ? 10497.0f : 33071.0f));
        GL11.glTexParameterf((int)3553, (int)10243, (float)(repeatY ? 10497.0f : 33071.0f));
        return texture;
    }

    public Object createTexture(int width, int height, boolean repeatX, boolean repeatY) {
        int tex = (Integer)this.createTexture(repeatX, repeatY);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, (ByteBuffer)null);
        return tex;
    }

    public void destroyTexture(Object tex) {
        this.flush();
        GL11.glDeleteTextures((int)((Integer)tex));
    }

    public void startClipped(int x, int y, int width, int height) {
        this.flush();
        GL11.glScissor((int)x, (int)(this.curFbufHeight - y - height), (int)width, (int)height);
        GL11.glEnable((int)3089);
    }

    public void endClipped() {
        this.flush();
        GL11.glDisable((int)3089);
    }

    public void clear(float r, float g, float b, float a) {
        GL11.glClearColor((float)r, (float)g, (float)b, (float)a);
        GL11.glClear((int)16384);
    }

    public void checkGLError(String op) {
        if (CHECK_ERRORS) {
            int error;
            while ((error = GL11.glGetError()) != 0) {
                PlayN.log().error(((Object)((Object)this)).getClass().getName() + " -- " + op + ": glError " + error);
            }
        }
    }

    protected void viewWasResized() {
        try {
            Display.setDisplayMode((DisplayMode)new DisplayMode(this.defaultFbufWidth, this.defaultFbufHeight));
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
        if (Display.isCreated()) {
            super.viewWasResized();
        }
    }

    protected Object defaultFrameBuffer() {
        return 0;
    }

    protected Object createFramebufferImpl(Object tex) {
        int fbuf = EXTFramebufferObject.glGenFramebuffersEXT();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)fbuf);
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36064, (int)3553, (int)((Integer)tex), (int)0);
        return fbuf;
    }

    protected void bindFramebufferImpl(Object fbuf, int width, int height) {
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)((Integer)fbuf));
        GL11.glViewport((int)0, (int)0, (int)width, (int)height);
    }

    protected GLShader.Texture quadTexShader() {
        return this.texShader;
    }

    protected GLShader.Texture trisTexShader() {
        return this.texShader;
    }

    protected GLShader.Color quadColorShader() {
        return this.colorShader;
    }

    protected GLShader.Color trisColorShader() {
        return this.colorShader;
    }

    void initGL() {
        try {
            Display.create();
            super.viewWasResized();
            GL11.glDisable((int)2884);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)1, (int)771);
            GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            this.texShader = new JavaGLShader.Texture(this);
            this.colorShader = new JavaGLShader.Color(this);
            this.checkGLError("initGL");
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
    }

    void paintLayers(GroupLayerGL rootLayer) {
        this.checkGLError("updateLayers Start");
        this.bindFramebuffer();
        GL11.glClear((int)16640);
        rootLayer.paint((InternalTransform)this.rootXform, 1.0f);
        this.checkGLError("updateLayers");
        this.useShader(null);
    }

    void updateTexture(int texture, BufferedImage image) {
        ByteBuffer buf = this.convertImageData(image);
        GL11.glBindTexture((int)3553, (int)texture);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)image.getWidth(), (int)image.getHeight(), (int)0, (int)6408, (int)5121, (ByteBuffer)buf);
        this.checkGLError("updateTexture");
    }

    private ByteBuffer convertImageData(BufferedImage img) {
        Asserts.checkNotNull((Object)img);
        ComponentColorModel glAlphaColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, false, 3, 0);
        WritableRaster raster = Raster.createInterleavedRaster(0, img.getWidth(), img.getHeight(), 4, null);
        BufferedImage texImage = new BufferedImage(glAlphaColorModel, raster, true, null);
        Graphics g = texImage.getGraphics();
        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        g.fillRect(0, 0, 256, 256);
        g.drawImage(img, 0, 0, null);
        DataBufferByte dbuf = (DataBufferByte)texImage.getRaster().getDataBuffer();
        ByteBuffer imageBuffer = ByteBuffer.allocateDirect(dbuf.getSize());
        imageBuffer.order(ByteOrder.nativeOrder());
        imageBuffer.put(dbuf.getData());
        imageBuffer.flip();
        return imageBuffer;
    }
}

