/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.opengl.Display;
import playn.core.CanvasImage;
import playn.core.Font;
import playn.core.Gradient;
import playn.core.Image;
import playn.core.Path;
import playn.core.Pattern;
import playn.core.PlayN;
import playn.core.TextFormat;
import playn.core.TextLayout;
import playn.core.gl.GL20;
import playn.core.gl.GLContext;
import playn.core.gl.GraphicsGL;
import playn.core.gl.GroupLayerGL;
import playn.core.gl.Scale;
import playn.java.JavaAssets;
import playn.java.JavaCanvasImage;
import playn.java.JavaErrorImage;
import playn.java.JavaFont;
import playn.java.JavaGL20;
import playn.java.JavaGLContext;
import playn.java.JavaGradient;
import playn.java.JavaImage;
import playn.java.JavaPath;
import playn.java.JavaPlatform;
import playn.java.JavaStaticImage;
import playn.java.JavaTextLayout;
import pythagoras.f.Point;

public class JavaGraphics
extends GraphicsGL {
    private final int DEFAULT_WIDTH = 640;
    private final int DEFAULT_HEIGHT = 480;
    private final GroupLayerGL rootLayer;
    private final JavaGLContext ctx;
    private JavaGL20 gl;
    protected Map<String, Font> _fonts = new HashMap<String, Font>();

    public JavaGraphics(JavaPlatform platform, float scaleFactor) {
        this.ctx = new JavaGLContext(platform, scaleFactor, 640, 480);
        this.rootLayer = new GroupLayerGL((GLContext)this.ctx);
    }

    public void registerFont(String name, String path) {
        try {
            Font font = Font.createFont(0, ((JavaAssets)PlayN.assets()).getAssetStream(path));
            this._fonts.put(name, font);
        }
        catch (Exception e) {
            PlayN.log().warn("Failed to load font [name=" + name + ", path=" + path + "]", (Throwable)e);
        }
    }

    public GroupLayerGL rootLayer() {
        return this.rootLayer;
    }

    public CanvasImage createImage(float width, float height) {
        return new JavaCanvasImage(this.ctx, width, height);
    }

    public Gradient createLinearGradient(float x0, float y0, float x1, float y1, int[] colors, float[] positions) {
        return JavaGradient.createLinear(x0, y0, x1, y1, positions, colors);
    }

    @Deprecated
    public Path createPath() {
        return new JavaPath();
    }

    @Deprecated
    public Pattern createPattern(Image img) {
        return img.toPattern();
    }

    public Gradient createRadialGradient(float x, float y, float r, int[] colors, float[] positions) {
        return JavaGradient.createRadial(x, y, r, positions, colors);
    }

    public playn.core.Font createFont(String name, Font.Style style, float size) {
        Font jfont = this._fonts.get(name);
        if (jfont == null) {
            jfont = new Font(name, 0, 12);
        }
        return new JavaFont(name, style, size, jfont);
    }

    public TextLayout layoutText(String text, TextFormat format) {
        return new JavaTextLayout(this, text, format);
    }

    public int screenWidth() {
        return Display.getDesktopDisplayMode().getWidth();
    }

    public int screenHeight() {
        return Display.getDesktopDisplayMode().getHeight();
    }

    public void setSize(int width, int height) {
        this.ctx.setSize(width, height);
    }

    public GL20 gl20() {
        if (this.gl == null) {
            this.gl = new JavaGL20();
        }
        return this.gl;
    }

    protected GLContext ctx() {
        return this.ctx;
    }

    protected JavaImage createStaticImage(BufferedImage source, Scale scale) {
        return new JavaStaticImage(this.ctx, source, scale);
    }

    protected JavaImage createErrorImage(Exception cause) {
        return new JavaErrorImage(this.ctx, cause);
    }

    void init() {
        this.ctx.initGL();
    }

    void transformMouse(Point point) {
        point.x /= this.ctx.scale.factor;
        point.y /= this.ctx.scale.factor;
    }

    void paintLayers() {
        if (this.gl == null) {
            this.ctx.paintLayers(this.rootLayer);
        }
    }
}

