/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import playn.core.Net;
import playn.core.util.Callback;
import playn.java.JavaPlatform;

public class JavaNet
implements Net {
    private static final int BUF_SIZE = 4096;
    private final JavaPlatform platform;

    public JavaNet(JavaPlatform platform) {
        this.platform = platform;
    }

    public void get(final String urlStr, final Callback<String> callback) {
        new Thread("JavaNet.get(" + urlStr + ")"){

            @Override
            public void run() {
                try {
                    URL url = new URL(JavaNet.this.canonicalizeUrl(urlStr));
                    InputStream stream = url.openStream();
                    InputStreamReader reader = new InputStreamReader(stream);
                    JavaNet.this.notifySuccess((Callback<String>)callback, JavaNet.this.readFully(reader));
                }
                catch (MalformedURLException e) {
                    JavaNet.this.notifyFailure((Callback<String>)callback, e);
                }
                catch (IOException e) {
                    JavaNet.this.notifyFailure((Callback<String>)callback, e);
                }
            }
        }.start();
    }

    public void post(final String urlStr, final String data, final Callback<String> callback) {
        new Thread("JavaNet.post(" + urlStr + ")"){

            @Override
            public void run() {
                try {
                    URL url = new URL(JavaNet.this.canonicalizeUrl(urlStr));
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("POST");
                    conn.setDoOutput(true);
                    conn.setDoInput(true);
                    conn.setAllowUserInteraction(false);
                    conn.setRequestProperty("Content-type", "text/xml; charset=UTF-8");
                    conn.connect();
                    conn.getOutputStream().write(data.getBytes("UTF-8"));
                    conn.getOutputStream().close();
                    String result = JavaNet.this.readFully(new InputStreamReader(conn.getInputStream()));
                    conn.disconnect();
                    JavaNet.this.notifySuccess((Callback<String>)callback, result);
                }
                catch (MalformedURLException e) {
                    JavaNet.this.notifyFailure((Callback<String>)callback, e);
                }
                catch (IOException e) {
                    JavaNet.this.notifyFailure((Callback<String>)callback, e);
                }
            }
        }.start();
    }

    void update() {
    }

    private String canonicalizeUrl(String url) {
        if (!url.startsWith("http")) {
            return "http://" + this.server() + url;
        }
        return url;
    }

    private String server() {
        return "127.0.0.1:8080";
    }

    private String readFully(Reader reader) throws IOException {
        StringBuffer result = new StringBuffer();
        char[] buf = new char[4096];
        int len = 0;
        while (-1 != (len = reader.read(buf))) {
            result.append(buf, 0, len);
        }
        return result.toString();
    }

    private void notifySuccess(final Callback<String> callback, final String result) {
        this.platform.invokeLater(new Runnable(){

            @Override
            public void run() {
                callback.onSuccess((Object)result);
            }
        });
    }

    private void notifyFailure(final Callback<String> callback, final Throwable cause) {
        this.platform.invokeLater(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(cause);
            }
        });
    }
}

