/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import playn.core.Canvas;
import playn.core.CanvasImage;
import playn.core.Image;
import playn.core.ResourceCallback;
import playn.core.gl.GLContext;
import playn.java.JavaCanvas;
import playn.java.JavaImage;

class JavaCanvasImage
extends JavaImage
implements CanvasImage {
    private final JavaCanvas canvas;

    JavaCanvasImage(GLContext ctx, float width, float height) {
        super(ctx, new BufferedImage(ctx.scale.scaledCeil(width), ctx.scale.scaledCeil(height), 2), ctx.scale);
        Graphics2D gfx = this.img.createGraphics();
        gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gfx.scale(ctx.scale.factor, ctx.scale.factor);
        this.canvas = new JavaCanvas(gfx, this.width(), this.height());
    }

    public Canvas canvas() {
        return this.canvas;
    }

    public void addCallback(ResourceCallback<? super Image> callback) {
        callback.done((Object)this);
    }

    public int ensureTexture(boolean repeatX, boolean repeatY) {
        if (this.canvas.dirty()) {
            this.canvas.clearDirty();
            this.clearTexture();
        }
        return super.ensureTexture(repeatX, repeatY);
    }
}

