/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import playn.core.Net;
import playn.core.NetImpl;
import playn.core.Platform;
import playn.core.util.Callback;
import playn.java.JavaPlatform;
import playn.java.JavaWebSocket;

public class JavaNet
extends NetImpl {
    private static final int BUF_SIZE = 4096;
    private List<JavaWebSocket> sockets = new ArrayList<JavaWebSocket>();

    public JavaNet(JavaPlatform platform) {
        super((Platform)platform);
    }

    public Net.WebSocket createWebSocket(String url, Net.WebSocket.Listener listener) {
        JavaWebSocket socket = new JavaWebSocket(url, listener);
        this.sockets.add(socket);
        return socket;
    }

    public void get(final String urlStr, final Callback<String> callback) {
        new Thread("JavaNet.get(" + urlStr + ")"){

            @Override
            public void run() {
                try {
                    URL url = new URL(JavaNet.this.canonicalizeUrl(urlStr));
                    InputStream stream = url.openStream();
                    InputStreamReader reader = new InputStreamReader(stream);
                    JavaNet.this.notifySuccess(callback, JavaNet.this.readFully(reader));
                }
                catch (MalformedURLException e) {
                    JavaNet.this.notifyFailure(callback, e);
                }
                catch (IOException e) {
                    JavaNet.this.notifyFailure(callback, e);
                }
            }
        }.start();
    }

    public void post(final String urlStr, final String data, final Callback<String> callback) {
        new Thread("JavaNet.post(" + urlStr + ")"){

            @Override
            public void run() {
                try {
                    URL url = new URL(JavaNet.this.canonicalizeUrl(urlStr));
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("POST");
                    conn.setDoOutput(true);
                    conn.setDoInput(true);
                    conn.setAllowUserInteraction(false);
                    conn.setRequestProperty("Content-type", "text/xml; charset=UTF-8");
                    conn.connect();
                    conn.getOutputStream().write(data.getBytes("UTF-8"));
                    conn.getOutputStream().close();
                    String result = JavaNet.this.readFully(new InputStreamReader(conn.getInputStream()));
                    conn.disconnect();
                    JavaNet.this.notifySuccess(callback, result);
                }
                catch (MalformedURLException e) {
                    JavaNet.this.notifyFailure(callback, e);
                }
                catch (IOException e) {
                    JavaNet.this.notifyFailure(callback, e);
                }
            }
        }.start();
    }

    void update() {
        Iterator<JavaWebSocket> it = this.sockets.iterator();
        while (it.hasNext()) {
            JavaWebSocket s = it.next();
            if (s.update()) continue;
            it.remove();
        }
    }

    private String canonicalizeUrl(String url) {
        if (!url.startsWith("http")) {
            return "http://" + this.server() + url;
        }
        return url;
    }

    private String server() {
        return "127.0.0.1:8080";
    }

    private String readFully(Reader reader) throws IOException {
        StringBuffer result = new StringBuffer();
        char[] buf = new char[4096];
        int len = 0;
        while (-1 != (len = reader.read(buf))) {
            result.append(buf, 0, len);
        }
        return result.toString();
    }
}

