/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.List;
import playn.core.AsyncImage;
import playn.core.Image;
import playn.core.gl.GLContext;
import playn.core.gl.Scale;
import playn.core.util.Callback;
import playn.core.util.Callbacks;
import playn.java.JavaImage;
import pythagoras.f.MathUtil;

public class JavaAsyncImage
extends JavaImage
implements AsyncImage<BufferedImage> {
    private List<Callback<? super Image>> callbacks;
    private Throwable error;
    private float preWidth;
    private float preHeight;

    public JavaAsyncImage(GLContext ctx, float preWidth, float preHeight) {
        super(ctx, null, Scale.ONE);
        this.preWidth = preWidth;
        this.preHeight = preHeight;
    }

    @Override
    public float width() {
        return this.img == null ? this.preWidth : super.width();
    }

    @Override
    public float height() {
        return this.img == null ? this.preHeight : super.height();
    }

    public void addCallback(Callback<? super Image> callback) {
        if (this.error != null) {
            callback.onFailure(this.error);
        } else if (this.img != null) {
            callback.onSuccess((Object)this);
        } else {
            this.callbacks = Callbacks.createAdd(this.callbacks, callback);
        }
    }

    public void setImage(BufferedImage img, Scale scale) {
        this.img = img;
        this.scale = scale;
        this.callbacks = Callbacks.dispatchSuccessClear(this.callbacks, (Object)((Object)this));
    }

    public void setError(Throwable error) {
        this.error = error;
        this.img = JavaAsyncImage.createErrorImage(this.preWidth == 0.0f ? 50.0f : this.preWidth, this.preHeight == 0.0f ? 50.0f : this.preHeight);
        this.callbacks = Callbacks.dispatchFailureClear(this.callbacks, (Throwable)error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage createErrorImage(float width, float height) {
        BufferedImage img = new BufferedImage(MathUtil.iceil((float)width), MathUtil.iceil((float)height), 2);
        Graphics2D g = img.createGraphics();
        try {
            g.setColor(Color.red);
            int yy = 0;
            while ((float)yy <= height / 15.0f) {
                int xx = 0;
                while ((float)xx <= width / 45.0f) {
                    g.drawString("ERROR", xx * 45, yy * 15);
                    ++xx;
                }
                ++yy;
            }
        }
        finally {
            g.dispose();
        }
        return img;
    }
}

