/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import playn.core.Asserts;
import playn.core.Platform;
import playn.core.gl.GL20;
import playn.core.gl.GL20Context;
import playn.java.JavaGL20;
import playn.java.JavaPlatform;

class JavaGLContext
extends GL20Context {
    public static final boolean CHECK_ERRORS = Boolean.getBoolean("playn.glerrors");

    JavaGLContext(JavaPlatform platform, float scaleFactor, int screenWidth, int screenHeight) {
        super((Platform)platform, (GL20)new JavaGL20(), scaleFactor, CHECK_ERRORS);
        this.setSize(screenWidth, screenHeight);
    }

    public void init() {
        try {
            Display.create();
            super.viewWasResized();
            super.init();
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
    }

    protected void viewWasResized() {
        try {
            Display.setDisplayMode((DisplayMode)new DisplayMode(this.defaultFbufWidth, this.defaultFbufHeight));
        }
        catch (LWJGLException e) {
            throw new RuntimeException(e);
        }
        if (Display.isCreated()) {
            super.viewWasResized();
        }
    }

    void updateTexture(int tex, BufferedImage image) {
        ByteBuffer buf = this.convertImageData(image);
        this.bindTexture(tex);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)image.getWidth(), (int)image.getHeight(), (int)0, (int)6408, (int)5121, (ByteBuffer)buf);
        this.checkGLError("updateTexture");
    }

    private ByteBuffer convertImageData(BufferedImage img) {
        Asserts.checkNotNull((Object)img);
        ComponentColorModel glAlphaColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, false, 3, 0);
        WritableRaster raster = Raster.createInterleavedRaster(0, img.getWidth(), img.getHeight(), 4, null);
        BufferedImage texImage = new BufferedImage(glAlphaColorModel, raster, true, null);
        Graphics g = texImage.getGraphics();
        g.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
        g.fillRect(0, 0, 256, 256);
        g.drawImage(img, 0, 0, null);
        DataBufferByte dbuf = (DataBufferByte)texImage.getRaster().getDataBuffer();
        ByteBuffer imageBuffer = ByteBuffer.allocateDirect(dbuf.getSize());
        imageBuffer.order(ByteOrder.nativeOrder());
        imageBuffer.put(dbuf.getData());
        imageBuffer.flip();
        return imageBuffer;
    }
}

