/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Desktop;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import playn.core.AbstractPlatform;
import playn.core.Analytics;
import playn.core.Game;
import playn.core.Json;
import playn.core.Keyboard;
import playn.core.Log;
import playn.core.Mouse;
import playn.core.Net;
import playn.core.Platform;
import playn.core.PlayN;
import playn.core.Pointer;
import playn.core.RegularExpression;
import playn.core.Storage;
import playn.core.Touch;
import playn.core.TouchImpl;
import playn.core.TouchStub;
import playn.core.json.JsonImpl;
import playn.java.JavaAnalytics;
import playn.java.JavaAssets;
import playn.java.JavaAudio;
import playn.java.JavaEmulatedTouch;
import playn.java.JavaGraphics;
import playn.java.JavaKeyboard;
import playn.java.JavaLog;
import playn.java.JavaMouse;
import playn.java.JavaNet;
import playn.java.JavaPointer;
import playn.java.JavaRegularExpression;
import playn.java.JavaStorage;

public class JavaPlatform
extends AbstractPlatform {
    private static final float MAX_DELTA = 100.0f;
    private static JavaPlatform testInstance;
    private final JavaAnalytics analytics = new JavaAnalytics();
    private final JavaAudio audio = new JavaAudio(this);
    private final JavaNet net = new JavaNet(this);
    private final JavaRegularExpression regex = new JavaRegularExpression();
    private final JavaStorage storage;
    private final JsonImpl json = new JsonImpl();
    private final JavaKeyboard keyboard = new JavaKeyboard();
    private final JavaPointer pointer = new JavaPointer();
    private final TouchImpl touch;
    private final JavaGraphics graphics;
    private final JavaMouse mouse;
    private final JavaAssets assets = new JavaAssets(this);
    private final ExecutorService _exec = Executors.newFixedThreadPool(4);
    private final long start = System.nanoTime();

    public static JavaPlatform register() {
        return JavaPlatform.register(new Config());
    }

    public static JavaPlatform register(Config config) {
        if (config.headless && testInstance != null) {
            return testInstance;
        }
        JavaPlatform instance = new JavaPlatform(config);
        if (config.headless) {
            testInstance = instance;
        }
        PlayN.setPlatform((Platform)instance);
        return instance;
    }

    private static float getDefaultScaleFactor() {
        String sfprop = System.getProperty("playn.scaleFactor", "1");
        try {
            return Float.parseFloat(sfprop);
        }
        catch (Exception e) {
            System.err.println("Invalid scaleFactor supplied '" + sfprop + "': " + e);
            return 1.0f;
        }
    }

    public JavaPlatform(Config config) {
        super((Log)new JavaLog());
        this.graphics = new JavaGraphics(this, config);
        this.storage = new JavaStorage(this, config);
        if (config.emulateTouch) {
            JavaEmulatedTouch emuTouch = new JavaEmulatedTouch();
            this.mouse = emuTouch.createMouse(this);
            this.touch = emuTouch;
        } else {
            this.mouse = new JavaMouse(this);
            this.touch = new TouchStub();
        }
    }

    public void setTitle(String title) {
        Display.setTitle((String)title);
    }

    public void invokeAsync(Runnable action) {
        this._exec.execute(action);
    }

    public Platform.Type type() {
        return Platform.Type.JAVA;
    }

    public JavaAudio audio() {
        return this.audio;
    }

    public JavaGraphics graphics() {
        return this.graphics;
    }

    public Json json() {
        return this.json;
    }

    public Keyboard keyboard() {
        return this.keyboard;
    }

    public Net net() {
        return this.net;
    }

    public Pointer pointer() {
        return this.pointer;
    }

    public Mouse mouse() {
        return this.mouse;
    }

    public Touch touch() {
        return this.touch;
    }

    public Storage storage() {
        return this.storage;
    }

    public Analytics analytics() {
        return this.analytics;
    }

    public JavaAssets assets() {
        return this.assets;
    }

    public RegularExpression regularExpression() {
        return this.regex;
    }

    public float random() {
        return (float)Math.random();
    }

    public double time() {
        return System.currentTimeMillis();
    }

    public int tick() {
        return (int)((System.nanoTime() - this.start) / 1000000L);
    }

    public void openURL(String url) {
        try {
            Desktop.getDesktop().browse(URI.create(url));
        }
        catch (Exception e) {
            this.log.warn("Failed to open URL [url=" + url + ", error=" + e + "]");
        }
    }

    public void setPropagateEvents(boolean propagate) {
        this.mouse.setPropagateEvents(propagate);
        this.touch.setPropagateEvents(propagate);
        this.pointer.setPropagateEvents(propagate);
    }

    public void run(Game game) {
        try {
            this.graphics.init();
            this.mouse.init();
            this.keyboard.init();
        }
        catch (LWJGLException e) {
            throw new RuntimeException("Unrecoverable initialization error", e);
        }
        game.init();
        boolean wasActive = Display.isActive();
        while (!Display.isCloseRequested()) {
            this.mouse.update();
            this.keyboard.update();
            this.pointer.update();
            if (wasActive != Display.isActive()) {
                if (wasActive) {
                    this.onPause();
                } else {
                    this.onResume();
                }
                wasActive = Display.isActive();
            }
            this.runQueue.execute();
            game.tick(this.tick());
            this.graphics.paint();
            Display.update();
            Display.sync((int)60);
        }
        this.onExit();
        try {
            this._exec.shutdown();
            this._exec.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(0);
    }

    private static long now() {
        return System.nanoTime() / 1000000L;
    }

    static /* synthetic */ float access$000() {
        return JavaPlatform.getDefaultScaleFactor();
    }

    public static class Config {
        public float scaleFactor = JavaPlatform.access$000();
        public boolean headless = false;
        public String storageFileName = "playn";
        public int width = 640;
        public int height = 480;
        public boolean emulateTouch;
    }
}

