/*
 * Decompiled with CFR 0.152.
 */
package sparsebitmap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class IntArray
implements Cloneable {
    private int[] array;
    private int size = 0;

    public IntArray() {
        this(8);
    }

    public IntArray(int capacity) {
        this.array = new int[capacity];
    }

    public IntArray clone() throws CloneNotSupportedException {
        IntArray clone = (IntArray)super.clone();
        clone.size = this.size;
        clone.array = Arrays.copyOf(this.array, this.size);
        return clone;
    }

    public void clear() {
        this.size = 0;
    }

    public int get(int index) {
        return this.array[index];
    }

    public int size() {
        return this.size;
    }

    public void set(int index, int value) {
        this.array[index] = value;
    }

    public void add(int value) {
        if (this.size + 1 >= this.array.length) {
            int newcapacity = this.array.length < 4 ? 4 : (this.array.length < 1024 ? 2 * this.array.length : 5 * this.array.length / 4);
            this.array = Arrays.copyOf(this.array, newcapacity);
        }
        this.array[this.size] = value;
        ++this.size;
    }

    public void removeLast() {
        --this.size;
    }

    public int trim() {
        this.array = Arrays.copyOf(this.array, this.size);
        return this.array.length;
    }

    public void serialize(DataOutput out) throws IOException {
        out.writeInt(this.size);
        for (int k = 0; k < this.size; ++k) {
            out.writeInt(this.array[k]);
        }
    }

    public void deserialize(DataInput in) throws IOException {
        this.size = in.readInt();
        if (this.array.length < this.size) {
            this.array = new int[this.size];
        }
        for (int k = 0; k < this.size; ++k) {
            this.array[k] = in.readInt();
        }
    }

    public int capacity() {
        return this.array.length;
    }

    public int hashCode() {
        int buf = 0;
        for (int k = 0; k < this.size; ++k) {
            buf = 31 * buf + this.array[k];
        }
        return buf;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntArray)) {
            return false;
        }
        IntArray objArray = (IntArray)obj;
        if (this.size != objArray.size) {
            return false;
        }
        for (int k = 0; k < this.size; ++k) {
            if (this.array[k] == objArray.array[k]) continue;
            return false;
        }
        return true;
    }
}

