/*
 * Decompiled with CFR 0.152.
 */
package sparsebitmap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import sparsebitmap.BitmapContainer;
import sparsebitmap.IntArray;
import sparsebitmap.IntIterator;
import sparsebitmap.SkippableIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseBitmap
implements Iterable<Integer>,
BitmapContainer,
Cloneable,
Externalizable {
    private static Comparator<SparseBitmap> smallfirst = new Comparator<SparseBitmap>(){

        @Override
        public int compare(SparseBitmap a, SparseBitmap b) {
            return a.sizeInBytes() - b.sizeInBytes();
        }
    };
    public int sizeinwords;
    public IntArray buffer;
    public static final int WORDSIZE = 32;

    @Override
    public void add(int wo, int off) {
        this.fastadd(wo, off);
    }

    private void fastadd(int wo, int off) {
        this.buffer.add(off - this.sizeinwords);
        this.buffer.add(wo);
        this.sizeinwords = off + 1;
    }

    public boolean equals(Object o) {
        if (o instanceof SparseBitmap) {
            return this.buffer.equals(((SparseBitmap)o).buffer);
        }
        return false;
    }

    public int hashCode() {
        return this.buffer.hashCode();
    }

    public int[] toArray() {
        IntIterator i = this.getIntIterator();
        int cardinality = this.cardinality();
        int[] answer = new int[cardinality];
        for (int k = 0; k < cardinality; ++k) {
            answer[k] = i.next();
        }
        return answer;
    }

    public String toString() {
        StringBuffer answer = new StringBuffer();
        IntIterator i = this.getIntIterator();
        answer.append("{");
        if (i.hasNext()) {
            answer.append(i.next());
        }
        while (i.hasNext()) {
            answer.append(",");
            answer.append(i.next());
        }
        answer.append("}");
        return answer.toString();
    }

    public static SparseBitmap bitmapOf(int ... k) {
        SparseBitmap s = new SparseBitmap();
        for (int i : k) {
            s.set(i);
        }
        return s;
    }

    public void set(int i) {
        int offset = i - this.sizeinwords * 32;
        if (offset + 32 < 0) {
            throw new IllegalArgumentException("unsupported write back");
        }
        if (offset + 32 >= 0 && offset < 0) {
            int before = this.buffer.get(this.buffer.size() - 1);
            this.buffer.set(this.buffer.size() - 1, before | 1 << offset + 32);
        } else {
            int numberofemptywords = offset / 32;
            this.fastadd(1 << (offset -= numberofemptywords * 32), this.sizeinwords + numberofemptywords);
        }
    }

    @Override
    public Iterator<Integer> iterator() {
        final IntIterator under = this.getIntIterator();
        return new Iterator<Integer>(){

            @Override
            public boolean hasNext() {
                return under.hasNext();
            }

            @Override
            public Integer next() {
                return new Integer(under.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("bitsets do not support remove");
            }
        };
    }

    public IntIterator getIntIterator() {
        return new IntIterator(){
            int wordindex;
            int i = 0;
            IntArray buf;
            int currentword;

            public IntIterator init(IntArray b) {
                this.buf = b;
                this.wordindex = this.buf.get(this.i);
                this.currentword = this.buf.get(this.i + 1);
                return this;
            }

            public boolean hasNext() {
                return this.currentword != 0;
            }

            public int next() {
                int offset = Integer.numberOfTrailingZeros(this.currentword);
                this.currentword ^= 1 << offset;
                int answer = this.wordindex * 32 + offset;
                if (this.currentword == 0) {
                    this.i += 2;
                    if (this.i < this.buf.size()) {
                        this.currentword = this.buf.get(this.i + 1);
                        this.wordindex += this.buf.get(this.i) + 1;
                    }
                }
                return answer;
            }
        }.init(this.buffer);
    }

    public SparseBitmap and(SparseBitmap o) {
        SparseBitmap a = new SparseBitmap();
        SparseBitmap.and2by2(a, this, o);
        return a;
    }

    public static void and2by2(BitmapContainer container, SparseBitmap bitmap1, SparseBitmap bitmap2) {
        int it1 = 0;
        int it2 = 0;
        int p1 = bitmap1.buffer.get(it1);
        int p2 = bitmap2.buffer.get(it2);
        while (true) {
            if (p1 < p2) {
                if (it1 + 2 >= bitmap1.buffer.size()) break;
                p1 += bitmap1.buffer.get(it1 += 2) + 1;
                continue;
            }
            if (p1 > p2) {
                if (it2 + 2 >= bitmap2.buffer.size()) break;
                p2 += bitmap2.buffer.get(it2 += 2) + 1;
                continue;
            }
            int buff = bitmap1.buffer.get(it1 + 1) & bitmap2.buffer.get(it2 + 1);
            if (buff != 0) {
                container.add(buff, p1);
            }
            if (it1 + 2 >= bitmap1.buffer.size() || it2 + 2 >= bitmap2.buffer.size()) break;
            p1 += bitmap1.buffer.get(it1 += 2) + 1;
            p2 += bitmap2.buffer.get(it2 += 2) + 1;
        }
    }

    public static SkippableIterator and(final SkippableIterator ... bitmap) {
        if (bitmap.length == 0) {
            throw new RuntimeException("nothing to process");
        }
        return new SkippableIterator(){
            int maxval;
            int wordval;
            boolean hasvalue = false;

            public boolean hasValue() {
                return this.hasvalue;
            }

            public SkippableIterator init() {
                this.hasvalue = false;
                for (SkippableIterator i : bitmap) {
                    if (i.hasValue()) continue;
                    return this;
                }
                this.maxval = bitmap[0].getCurrentWordOffset();
                for (int k = 1; k < bitmap.length; ++k) {
                    if (this.maxval >= bitmap[k].getCurrentWordOffset()) continue;
                    this.maxval = bitmap[k].getCurrentWordOffset();
                }
                this.movetonext();
                return this;
            }

            public void movetonext() {
                int k;
                boolean stable;
                this.hasvalue = false;
                do {
                    stable = true;
                    for (k = 0; k < bitmap.length; ++k) {
                        if (bitmap[k].getCurrentWordOffset() >= this.maxval) continue;
                        bitmap[k].advanceUntil(this.maxval);
                        if (!bitmap[k].hasValue()) {
                            return;
                        }
                        this.maxval = bitmap[k].getCurrentWordOffset();
                        stable = false;
                    }
                } while (!stable);
                this.wordval = bitmap[0].getCurrentWord();
                for (k = 1; k < bitmap.length; ++k) {
                    this.wordval &= bitmap[k].getCurrentWord();
                }
                if (this.wordval == 0) {
                    this.advance();
                } else {
                    this.hasvalue = true;
                }
            }

            public void advance() {
                for (SkippableIterator b : bitmap) {
                    b.advanceUntil(this.maxval);
                    if (!b.hasValue()) {
                        this.hasvalue = false;
                        return;
                    }
                    this.maxval = b.getCurrentWordOffset();
                }
                this.movetonext();
            }

            public void advanceUntil(int min) {
                bitmap[bitmap.length - 1].advanceUntil(min);
                if (!bitmap[bitmap.length - 1].hasValue()) {
                    this.hasvalue = false;
                    return;
                }
                this.maxval = bitmap[bitmap.length - 1].getCurrentWordOffset();
                this.movetonext();
            }

            public int getCurrentWord() {
                return this.wordval;
            }

            public int getCurrentWordOffset() {
                return this.maxval;
            }
        }.init();
    }

    public static SkippableIterator fastand(final SkippableIterator ... bitmap) {
        if (bitmap.length == 0) {
            throw new RuntimeException("nothing to process");
        }
        return new SkippableIterator(){
            int maxval;
            int wordval;
            boolean hasvalue = false;
            int sbscardinality = 0;

            public boolean hasValue() {
                return this.hasvalue;
            }

            public SkippableIterator init() {
                int k;
                this.hasvalue = false;
                for (SkippableIterator i : bitmap) {
                    if (i.hasValue()) continue;
                    return this;
                }
                this.maxval = bitmap[0].getCurrentWordOffset();
                this.sbscardinality = 1;
                for (k = 1; k < bitmap.length; ++k) {
                    if (this.maxval < bitmap[k].getCurrentWordOffset()) {
                        this.maxval = bitmap[k].getCurrentWordOffset();
                        this.sbscardinality = 1;
                        continue;
                    }
                    ++this.sbscardinality;
                }
                while (this.sbscardinality < bitmap.length) {
                    for (k = 0; k < bitmap.length; ++k) {
                        if (bitmap[k].getCurrentWordOffset() == this.maxval) {
                            ++this.sbscardinality;
                            if (this.sbscardinality != bitmap.length) continue;
                            break;
                        }
                        if (bitmap[k].getCurrentWordOffset() >= this.maxval) continue;
                        bitmap[k].advanceUntil(this.maxval);
                        if (!bitmap[k].hasValue()) {
                            return this;
                        }
                        this.maxval = bitmap[k].getCurrentWordOffset();
                        this.sbscardinality = 1;
                    }
                    this.wordval = bitmap[0].getCurrentWord();
                    for (k = 1; k < bitmap.length; ++k) {
                        this.wordval &= bitmap[k].getCurrentWord();
                    }
                    if (this.wordval == 0) {
                        this.advance();
                        continue;
                    }
                    this.hasvalue = true;
                }
                return this;
            }

            public void movetonext() {
                block0: while (this.sbscardinality < bitmap.length) {
                    for (int i = 0; i < bitmap.length; ++i) {
                        bitmap[i].advanceUntil(this.maxval);
                        if (!bitmap[i].hasValue()) {
                            this.hasvalue = false;
                            return;
                        }
                        if (bitmap[i].getCurrentWordOffset() > this.maxval) {
                            this.maxval = bitmap[i].getCurrentWordOffset();
                            this.sbscardinality = 1;
                            continue block0;
                        }
                        ++this.sbscardinality;
                    }
                }
                this.wordval = bitmap[0].getCurrentWord();
                for (int k = 1; k < bitmap.length; ++k) {
                    this.wordval &= bitmap[k].getCurrentWord();
                }
                if (this.wordval == 0) {
                    this.advance();
                } else {
                    this.hasvalue = true;
                }
            }

            public void advance() {
                bitmap[0].advance();
                if (!bitmap[0].hasValue()) {
                    this.hasvalue = false;
                    return;
                }
                this.sbscardinality = 1;
                this.maxval = bitmap[0].getCurrentWordOffset();
                for (int k = 1; k < bitmap.length; ++k) {
                    SkippableIterator b = bitmap[k];
                    b.advanceUntil(this.maxval);
                    if (!b.hasValue()) {
                        this.hasvalue = false;
                        return;
                    }
                    if (b.getCurrentWordOffset() > this.maxval) {
                        this.maxval = b.getCurrentWordOffset();
                        this.sbscardinality = 1;
                        continue;
                    }
                    ++this.sbscardinality;
                }
                this.movetonext();
            }

            public void advanceUntil(int min) {
                throw new InternalError("not implemented");
            }

            public int getCurrentWord() {
                return this.wordval;
            }

            public int getCurrentWordOffset() {
                return this.maxval;
            }
        }.init();
    }

    public static SkippableIterator treeand(SkippableIterator ... bitmap) {
        if (bitmap.length == 0) {
            throw new RuntimeException("nothing to process");
        }
        if (bitmap.length == 1) {
            return bitmap[0];
        }
        if (bitmap.length == 2) {
            return SparseBitmap.and2by2(bitmap[0], bitmap[1]);
        }
        if ((bitmap.length & 1) == 0) {
            SkippableIterator[] si = new SkippableIterator[bitmap.length / 2];
            for (int i = 0; i < si.length; ++i) {
                si[i] = SparseBitmap.and2by2(bitmap[2 * i], bitmap[2 * i + 1]);
            }
            return SparseBitmap.treeand(si);
        }
        SkippableIterator[] si = new SkippableIterator[bitmap.length / 2 + 1];
        for (int i = 0; i < si.length - 1; ++i) {
            si[i] = SparseBitmap.and2by2(bitmap[2 * i], bitmap[2 * i + 1]);
        }
        si[si.length - 1] = bitmap[bitmap.length - 1];
        return SparseBitmap.treeand(si);
    }

    public static SkippableIterator flatand(SkippableIterator ... bitmap) {
        if (bitmap.length == 0) {
            throw new RuntimeException("nothing to process");
        }
        SkippableIterator answer = bitmap[0];
        for (int k = 1; k < bitmap.length; ++k) {
            answer = SparseBitmap.and2by2(answer, bitmap[k]);
        }
        return answer;
    }

    public static SkippableIterator reverseflatand(SkippableIterator ... bitmap) {
        if (bitmap.length == 0) {
            throw new RuntimeException("nothing to process");
        }
        SkippableIterator answer = bitmap[bitmap.length - 1];
        for (int k = bitmap.length - 1; k > 0; --k) {
            answer = SparseBitmap.and2by2(answer, bitmap[k]);
        }
        return answer;
    }

    public static SparseBitmap materialize(SkippableIterator i) {
        SparseBitmap answer = new SparseBitmap();
        while (i.hasValue()) {
            answer.add(i.getCurrentWord(), i.getCurrentWordOffset());
            i.advance();
        }
        return answer;
    }

    public static int cardinality(SkippableIterator i) {
        int card = 0;
        while (i.hasValue()) {
            card += Integer.bitCount(i.getCurrentWord());
            i.advance();
        }
        return card;
    }

    public static SkippableIterator and2by2(final SkippableIterator bitmap1, final SkippableIterator bitmap2) {
        return new SkippableIterator(){
            boolean hasvalue = false;
            int currentword = 0;

            public boolean hasValue() {
                return this.hasvalue;
            }

            public SkippableIterator init() {
                this.movetonext();
                return this;
            }

            public void movetonext() {
                this.hasvalue = false;
                if (bitmap1.hasValue() && bitmap2.hasValue()) {
                    while (true) {
                        if (bitmap1.getCurrentWordOffset() < bitmap2.getCurrentWordOffset()) {
                            bitmap1.advanceUntil(bitmap2.getCurrentWordOffset());
                            if (bitmap1.hasValue()) continue;
                            return;
                        }
                        if (bitmap1.getCurrentWordOffset() > bitmap2.getCurrentWordOffset()) {
                            bitmap2.advanceUntil(bitmap1.getCurrentWordOffset());
                            if (bitmap2.hasValue()) continue;
                            return;
                        }
                        this.currentword = bitmap1.getCurrentWord() & bitmap2.getCurrentWord();
                        if (this.currentword != 0) {
                            this.hasvalue = true;
                            return;
                        }
                        bitmap1.advance();
                        if (!bitmap1.hasValue()) break;
                        bitmap2.advanceUntil(bitmap1.getCurrentWordOffset());
                        if (!bitmap2.hasValue()) break;
                    }
                    return;
                }
            }

            public void advance() {
                bitmap1.advance();
                if (bitmap1.hasValue()) {
                    bitmap2.advanceUntil(bitmap1.getCurrentWordOffset());
                    this.movetonext();
                } else {
                    this.hasvalue = false;
                }
            }

            public void advanceUntil(int min) {
                bitmap1.advanceUntil(min);
                if (bitmap1.hasValue()) {
                    bitmap2.advanceUntil(bitmap1.getCurrentWordOffset());
                    this.movetonext();
                } else {
                    this.hasvalue = false;
                }
            }

            public int getCurrentWord() {
                return this.currentword;
            }

            public int getCurrentWordOffset() {
                return bitmap1.getCurrentWordOffset();
            }
        }.init();
    }

    public SparseBitmap or(SparseBitmap o) {
        SparseBitmap a = new SparseBitmap();
        SparseBitmap.or2by2(a, this, o);
        return a;
    }

    public static void or2by2(BitmapContainer container, SparseBitmap bitmap1, SparseBitmap bitmap2) {
        int it1 = 0;
        int it2 = 0;
        int p1 = bitmap1.buffer.get(it1);
        int p2 = bitmap2.buffer.get(it2);
        if (it1 < bitmap1.buffer.size() && it2 < bitmap2.buffer.size()) {
            while (true) {
                if (p1 < p2) {
                    container.add(bitmap1.buffer.get(it1 + 1), p1);
                    if ((it1 += 2) >= bitmap1.buffer.size()) break;
                    p1 += bitmap1.buffer.get(it1) + 1;
                    continue;
                }
                if (p1 > p2) {
                    container.add(bitmap2.buffer.get(it2 + 1), p2);
                    if ((it2 += 2) >= bitmap2.buffer.size()) break;
                    p2 += bitmap2.buffer.get(it2) + 1;
                    continue;
                }
                container.add(bitmap1.buffer.get(it1 + 1) | bitmap2.buffer.get(it2 + 1), p1);
                it2 += 2;
                if ((it1 += 2) < bitmap1.buffer.size()) {
                    p1 += bitmap1.buffer.get(it1) + 1;
                }
                if (it2 < bitmap2.buffer.size()) {
                    p2 += bitmap2.buffer.get(it2) + 1;
                }
                if (it1 >= bitmap1.buffer.size() || it2 >= bitmap2.buffer.size()) break;
            }
        }
        if (it1 < bitmap1.buffer.size()) {
            while (true) {
                container.add(bitmap1.buffer.get(it1 + 1), p1);
                if ((it1 += 2) == bitmap1.buffer.size()) break;
                p1 += bitmap1.buffer.get(it1) + 1;
            }
        }
        if (it2 < bitmap2.buffer.size()) {
            while (true) {
                container.add(bitmap2.buffer.get(it2 + 1), p2);
                if ((it2 += 2) == bitmap2.buffer.size()) break;
                p2 += bitmap2.buffer.get(it2) + 1;
            }
        }
        while (it2 < bitmap2.buffer.size()) {
            container.add(bitmap2.buffer.get(it2 + 1), p2);
            p2 += bitmap2.buffer.get(it2 += 2) + 1;
        }
    }

    public SparseBitmap xor(SparseBitmap o) {
        SparseBitmap a = new SparseBitmap();
        SparseBitmap.xor2by2(a, this, o);
        return a;
    }

    public static void xor2by2(BitmapContainer container, SparseBitmap bitmap1, SparseBitmap bitmap2) {
        int it1 = 0;
        int it2 = 0;
        int p1 = bitmap1.buffer.get(it1);
        int p2 = bitmap2.buffer.get(it2);
        if (it1 < bitmap1.buffer.size() && it2 < bitmap2.buffer.size()) {
            while (true) {
                if (p1 < p2) {
                    container.add(bitmap1.buffer.get(it1 + 1), p1);
                    if ((it1 += 2) >= bitmap1.buffer.size()) break;
                    p1 += bitmap1.buffer.get(it1) + 1;
                    continue;
                }
                if (p1 > p2) {
                    container.add(bitmap2.buffer.get(it2 + 1), p2);
                    if ((it2 += 2) >= bitmap2.buffer.size()) break;
                    p2 += bitmap2.buffer.get(it2) + 1;
                    continue;
                }
                if (bitmap1.buffer.get(it1 + 1) != bitmap2.buffer.get(it2 + 1)) {
                    container.add(bitmap1.buffer.get(it1 + 1) ^ bitmap2.buffer.get(it2 + 1), p1);
                }
                it2 += 2;
                if ((it1 += 2) < bitmap1.buffer.size()) {
                    p1 += bitmap1.buffer.get(it1) + 1;
                }
                if (it2 < bitmap2.buffer.size()) {
                    p2 += bitmap2.buffer.get(it2) + 1;
                }
                if (it1 >= bitmap1.buffer.size() || it2 >= bitmap2.buffer.size()) break;
            }
        }
        if (it1 < bitmap1.buffer.size()) {
            while (true) {
                container.add(bitmap1.buffer.get(it1 + 1), p1);
                if ((it1 += 2) == bitmap1.buffer.size()) break;
                p1 += bitmap1.buffer.get(it1) + 1;
            }
        }
        if (it2 < bitmap2.buffer.size()) {
            while (true) {
                container.add(bitmap2.buffer.get(it2 + 1), p2);
                if ((it2 += 2) == bitmap2.buffer.size()) break;
                p2 += bitmap2.buffer.get(it2) + 1;
            }
        }
        while (it2 < bitmap2.buffer.size()) {
            System.out.println("==***= p1 =" + p1 + " p2 = " + p2);
            System.out.println("34%%  p2 = " + p2);
            container.add(bitmap2.buffer.get(it2 + 1), p2);
            p2 += bitmap2.buffer.get(it2 += 2) + 1;
        }
    }

    public static SparseBitmap and(SparseBitmap ... bitmaps) {
        if (bitmaps.length == 0) {
            return new SparseBitmap();
        }
        if (bitmaps.length == 1) {
            return bitmaps[0];
        }
        if (bitmaps.length == 2) {
            return bitmaps[0].and(bitmaps[1]);
        }
        PriorityQueue<SparseBitmap> pq = new PriorityQueue<SparseBitmap>(bitmaps.length, smallfirst);
        for (SparseBitmap x : bitmaps) {
            pq.add(x);
        }
        while (pq.size() > 1) {
            SparseBitmap x1 = pq.poll();
            SparseBitmap x2 = pq.poll();
            pq.add(x1.and(x2));
        }
        return pq.poll();
    }

    public static SkippableIterator fastand(SparseBitmap ... bitmaps) {
        SkippableIterator[] si = new SkippableIterator[bitmaps.length];
        for (int k = 0; k < bitmaps.length; ++k) {
            si[k] = bitmaps[k].getSkippableIterator();
        }
        return SparseBitmap.fastand(si);
    }

    public static SparseBitmap or(SparseBitmap ... bitmaps) {
        if (bitmaps.length == 0) {
            return new SparseBitmap();
        }
        if (bitmaps.length == 1) {
            return bitmaps[0];
        }
        if (bitmaps.length == 2) {
            return bitmaps[0].or(bitmaps[1]);
        }
        PriorityQueue<SparseBitmap> pq = new PriorityQueue<SparseBitmap>(bitmaps.length, smallfirst);
        for (SparseBitmap x : bitmaps) {
            pq.add(x);
        }
        while (pq.size() > 1) {
            SparseBitmap x1 = pq.poll();
            SparseBitmap x2 = pq.poll();
            pq.add(x1.or(x2));
        }
        return pq.poll();
    }

    public static SparseBitmap xor(SparseBitmap ... bitmaps) {
        if (bitmaps.length == 0) {
            return new SparseBitmap();
        }
        if (bitmaps.length == 1) {
            return bitmaps[0];
        }
        if (bitmaps.length == 2) {
            return bitmaps[0].or(bitmaps[1]);
        }
        PriorityQueue<SparseBitmap> pq = new PriorityQueue<SparseBitmap>(bitmaps.length, smallfirst);
        for (SparseBitmap x : bitmaps) {
            pq.add(x);
        }
        while (pq.size() > 1) {
            SparseBitmap x1 = pq.poll();
            SparseBitmap x2 = pq.poll();
            pq.add(x1.xor(x2));
        }
        return pq.poll();
    }

    public int sizeInBytes() {
        return this.buffer.size() * 4;
    }

    public int trim() {
        return this.buffer.trim();
    }

    public SparseBitmap() {
        this.buffer = new IntArray();
    }

    public SparseBitmap(int expectedstoragesize) {
        this.buffer = new IntArray(expectedstoragesize);
    }

    public SkippableIterator getSkippableIterator() {
        return new SkippableIterator(){
            int pos = 0;
            int p = 0;

            public SkippableIterator init() {
                this.p = SparseBitmap.this.buffer.get(0);
                return this;
            }

            public void advance() {
                this.pos += 2;
                if (this.pos < SparseBitmap.this.buffer.size()) {
                    this.p += SparseBitmap.this.buffer.get(this.pos) + 1;
                }
            }

            public void advanceUntil(int min) {
                this.advance();
                while (this.hasValue() && this.getCurrentWordOffset() < min) {
                    this.advance();
                }
            }

            public int getCurrentWord() {
                return SparseBitmap.this.buffer.get(this.pos + 1);
            }

            public int getCurrentWordOffset() {
                return this.p;
            }

            public boolean hasValue() {
                return this.pos < SparseBitmap.this.buffer.size();
            }
        }.init();
    }

    public static boolean match(SkippableIterator o1, SkippableIterator o2) {
        while (o1.getCurrentWordOffset() != o2.getCurrentWordOffset()) {
            if (o1.getCurrentWordOffset() < o2.getCurrentWordOffset()) {
                o1.advanceUntil(o2.getCurrentWordOffset());
                if (!o1.hasValue()) {
                    return false;
                }
            }
            if (o1.getCurrentWordOffset() <= o2.getCurrentWordOffset()) continue;
            o2.advanceUntil(o1.getCurrentWordOffset());
            if (o2.hasValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    public void serialize(DataOutput out) throws IOException {
        this.buffer.serialize(out);
    }

    public void deserialize(DataInput in) throws IOException {
        this.buffer.deserialize(in);
        for (int k = 0; k < this.buffer.size(); k += 2) {
            this.sizeinwords += this.buffer.get(k) + 1;
        }
    }

    public int cardinality() {
        int answer = 0;
        for (int k = 0; k < this.buffer.size(); k += 2) {
            answer += Integer.bitCount(this.buffer.get(k + 1));
        }
        return answer;
    }

    public void clear() {
        this.buffer.clear();
        this.sizeinwords = 0;
    }

    public Object clone() throws CloneNotSupportedException {
        SparseBitmap b = (SparseBitmap)super.clone();
        b.buffer = this.buffer.clone();
        b.sizeinwords = this.sizeinwords;
        return b;
    }
}

